/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import xreliquary.api.IPedestalItemWrapper;

@Mod.EventBusSubscriber(modid="xreliquary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PedestalRegistry {
    private static final PedestalRegistry INSTANCE = new PedestalRegistry();
    private static final Map<LocationKey, BlockPos> positions = new HashMap<LocationKey, BlockPos>();
    private Map<Class<? extends Item>, Supplier<? extends IPedestalItemWrapper>> itemWrappers = new HashMap<Class<? extends Item>, Supplier<? extends IPedestalItemWrapper>>();
    private Map<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>> blockWrappers = new HashMap<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>>();

    public static void registerItemWrapper(Class<? extends Item> itemClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.itemWrappers.put(itemClass, wrapperClass);
    }

    public static void registerItemBlockWrapper(Class<? extends Block> blockClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.blockWrappers.put(blockClass, wrapperClass);
    }

    public static Optional<IPedestalItemWrapper> getItemWrapper(ItemStack item) {
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.itemWrappers.keySet()) {
            if (!clazz.isInstance(item.func_77973_b())) continue;
            return Optional.of(PedestalRegistry.INSTANCE.itemWrappers.get(clazz).get());
        }
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.blockWrappers.keySet()) {
            if (!(item.func_77973_b() instanceof BlockItem) || !clazz.isInstance(((BlockItem)item.func_77973_b()).func_179223_d())) continue;
            return Optional.of(PedestalRegistry.INSTANCE.blockWrappers.get(clazz).get());
        }
        return Optional.empty();
    }

    public static void registerPosition(int dimensionId, BlockPos pos) {
        LocationKey key = new LocationKey(dimensionId, pos.func_218275_a());
        if (!positions.containsKey(key)) {
            positions.put(key, pos);
        }
    }

    public static void unregisterPosition(int dimensionId, BlockPos pos) {
        positions.remove(new LocationKey(dimensionId, pos.func_218275_a()));
    }

    private static void clearPositions() {
        positions.clear();
    }

    public static List<BlockPos> getPositionsInRange(int dimensionId, BlockPos startPos, int range) {
        return PedestalRegistry.getPositionsInRange(dimensionId, startPos, range, range, range);
    }

    private static List<BlockPos> getPositionsInRange(int dimensionId, BlockPos startPos, int xRange, int yRange, int zRange) {
        ArrayList<BlockPos> positionsInRange = new ArrayList<BlockPos>();
        for (Map.Entry<LocationKey, BlockPos> position : positions.entrySet()) {
            BlockPos pos;
            if (position.getKey().getDimensionId() != dimensionId || (pos = position.getValue()).func_177958_n() < startPos.func_177958_n() - xRange || pos.func_177958_n() > startPos.func_177958_n() + xRange || pos.func_177956_o() < startPos.func_177956_o() - yRange || pos.func_177956_o() > startPos.func_177956_o() + yRange || pos.func_177952_p() < startPos.func_177952_p() - zRange || pos.func_177952_p() > startPos.func_177952_p() + zRange) continue;
            positionsInRange.add(pos);
        }
        return positionsInRange;
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppedEvent event) {
        PedestalRegistry.clearPositions();
    }

    private static class LocationKey {
        private int dimensionId;
        private long location;

        LocationKey(int dimensionId, long location) {
            this.dimensionId = dimensionId;
            this.location = location;
        }

        public int hashCode() {
            return Long.hashCode(this.location + (long)this.dimensionId);
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocationKey)) {
                return false;
            }
            LocationKey key2 = (LocationKey)o;
            return this.getDimensionId() == key2.getDimensionId() && this.getLocation() == key2.getLocation();
        }

        int getDimensionId() {
            return this.dimensionId;
        }

        public long getLocation() {
            return this.location;
        }
    }
}

