/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import xreliquary.compat.curios.CuriosCompat;
import xreliquary.init.ModItems;
import xreliquary.items.util.IBaubleItem;

public class PacketFortuneCoinTogglePressed {
    private InventoryType inventoryType;
    private int slot;

    public PacketFortuneCoinTogglePressed(InventoryType inventoryType, int slot) {
        this.inventoryType = inventoryType;
        this.slot = slot;
    }

    static void encode(PacketFortuneCoinTogglePressed msg, PacketBuffer packetBuffer) {
        packetBuffer.writeByte(msg.inventoryType.ordinal());
        packetBuffer.writeInt(msg.slot);
    }

    static PacketFortuneCoinTogglePressed decode(PacketBuffer packetBuffer) {
        return new PacketFortuneCoinTogglePressed(InventoryType.values()[packetBuffer.readByte()], packetBuffer.readInt());
    }

    static void onMessage(PacketFortuneCoinTogglePressed msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketFortuneCoinTogglePressed.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(PacketFortuneCoinTogglePressed message, ServerPlayerEntity player) {
        switch (message.inventoryType) {
            case MAIN: {
                ItemStack stack2 = (ItemStack)player.field_71071_by.field_70462_a.get(message.slot);
                if (stack2.func_77973_b() != ModItems.FORTUNE_COIN) break;
                ModItems.FORTUNE_COIN.toggle(stack2);
                break;
            }
            case OFF_HAND: {
                ItemStack stack1 = (ItemStack)player.field_71071_by.field_184439_c.get(0);
                if (stack1.func_77973_b() != ModItems.FORTUNE_COIN) break;
                ModItems.FORTUNE_COIN.toggle(stack1);
                break;
            }
            case CURIOS: {
                PacketFortuneCoinTogglePressed.run(() -> () -> CuriosCompat.getStackInSlot((LivingEntity)player, IBaubleItem.Type.NECKLACE.getIdentifier(), message.slot).ifPresent(stack -> {
                    if (stack.func_77973_b() == ModItems.FORTUNE_COIN) {
                        ModItems.FORTUNE_COIN.toggle((ItemStack)stack);
                        CuriosCompat.setStackInSlot((LivingEntity)player, IBaubleItem.Type.NECKLACE.getIdentifier(), message.slot, stack);
                    }
                }));
            }
        }
    }

    private static void run(Supplier<Runnable> toRun) {
        toRun.get().run();
    }

    public static enum InventoryType {
        MAIN,
        OFF_HAND,
        CURIOS;

    }
}

