/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.Constants;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.log.ChatLog;
import journeymap.client.model.Waypoint;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public enum KeyEventHandler implements EventHandlerManager.EventHandler
{
    INSTANCE;

    public KeyBinding kbMapZoomin;
    public KeyBinding kbMapZoomout;
    public KeyBinding kbMapToggleType;
    public KeyBinding kbCreateWaypoint;
    public KeyBinding kbToggleAllWaypoints;
    public KeyBinding kbFullscreenCreateWaypoint;
    public KeyBinding kbFullscreenChatPosition;
    public KeyBinding kbFullscreenToggle;
    public KeyBinding kbWaypointManager;
    public KeyBinding kbMinimapToggle;
    public KeyBinding kbMinimapPreset;
    public KeyBinding kbFullmapOptionsManager;
    public KeyBinding kbFullmapPanNorth;
    public KeyBinding kbFullmapPanSouth;
    public KeyBinding kbFullmapPanEast;
    public KeyBinding kbFullmapPanWest;
    private Comparator<KeyBindingAction> kbaComparator = Comparator.comparingInt(KeyBindingAction::order);
    private final ListMultimap<Integer, KeyBindingAction> minimapPreviewActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    private final ListMultimap<Integer, KeyBindingAction> inGameActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    private final ListMultimap<Integer, KeyBindingAction> inGuiActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    private Minecraft mc = Minecraft.func_71410_x();
    private boolean sortActionsNeeded = true;
    private Logger logger = Journeymap.getLogger();

    private KeyEventHandler() {
        this.kbMapZoomin = this.register("key.journeymap.zoom_in", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 61);
        this.setAction(this.minimapPreviewActions, this.kbMapZoomin, () -> MiniMap.state().zoomIn());
        this.setAction(this.inGuiActions, this.kbMapZoomin, () -> this.getFullscreen().zoomIn());
        this.kbMapZoomout = this.register("key.journeymap.zoom_out", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 45);
        this.setAction(this.minimapPreviewActions, this.kbMapZoomout, () -> MiniMap.state().zoomOut());
        this.setAction(this.inGuiActions, this.kbMapZoomout, () -> this.getFullscreen().zoomOut());
        this.kbMapToggleType = this.register("key.journeymap.minimap_type", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 91);
        this.setAction(this.minimapPreviewActions, this.kbMapToggleType, () -> MiniMap.state().toggleMapType());
        this.setAction(this.inGuiActions, this.kbMapToggleType, () -> this.getFullscreen().toggleMapType());
        this.kbMinimapPreset = this.register("key.journeymap.minimap_preset", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 92);
        this.setAction(this.minimapPreviewActions, this.kbMinimapPreset, UIManager.INSTANCE::switchMiniMapPreset);
        this.inGameActions.putAll(this.minimapPreviewActions);
        this.kbCreateWaypoint = this.register("key.journeymap.create_waypoint", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 66);
        this.setAction(this.inGameActions, this.kbCreateWaypoint, () -> {
            this.mc.field_195559_v.func_197967_a(false);
            UIManager.INSTANCE.openWaypointEditor(Waypoint.of((PlayerEntity)this.mc.field_71439_g), true, null);
        });
        this.kbToggleAllWaypoints = this.register("key.journeymap.toggle_waypoints", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 90);
        this.setAction(this.inGameActions, this.kbToggleAllWaypoints, () -> WaypointManager.toggleAllWaypoints());
        this.kbFullscreenCreateWaypoint = this.register("key.journeymap.fullscreen_create_waypoint", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 66);
        this.setAction(this.inGuiActions, this.kbFullscreenCreateWaypoint, () -> this.getFullscreen().createWaypointAtMouse());
        this.kbFullscreenChatPosition = this.register("key.journeymap.fullscreen_chat_position", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 67);
        this.setAction(this.inGuiActions, this.kbFullscreenChatPosition, () -> this.getFullscreen().chatPositionAtMouse());
        this.kbFullscreenToggle = this.register("key.journeymap.map_toggle_alt", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 74);
        this.setAction(this.inGameActions, this.kbFullscreenToggle, UIManager.INSTANCE::openFullscreenMap);
        this.setAction(this.inGuiActions, this.kbFullscreenToggle, UIManager.INSTANCE::closeAll);
        this.kbWaypointManager = this.register("key.journeymap.fullscreen_waypoints", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, 66);
        this.setAction(this.inGameActions, this.kbWaypointManager, () -> UIManager.INSTANCE.openWaypointManager(null, null));
        this.setAction(this.inGuiActions, this.kbWaypointManager, () -> UIManager.INSTANCE.openWaypointManager(null, this.getFullscreen()));
        this.kbMinimapToggle = this.register("key.journeymap.minimap_toggle_alt", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 74);
        this.setAction(this.inGameActions, this.kbMinimapToggle, UIManager.INSTANCE::toggleMinimap);
        this.kbFullmapOptionsManager = this.register("key.journeymap.fullscreen_options", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 79);
        this.setAction(this.inGuiActions, this.kbFullmapOptionsManager, () -> UIManager.INSTANCE.openOptionsManager(this.getFullscreen(), new Category[0]));
        this.kbFullmapPanNorth = this.register("key.journeymap.fullscreen.north", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 265);
        this.setAction(this.inGuiActions, this.kbFullmapPanNorth, () -> this.getFullscreen().moveCanvas(0, -16));
        this.kbFullmapPanSouth = this.register("key.journeymap.fullscreen.south", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 264);
        this.setAction(this.inGuiActions, this.kbFullmapPanSouth, () -> this.getFullscreen().moveCanvas(0, 16));
        this.kbFullmapPanEast = this.register("key.journeymap.fullscreen.east", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 262);
        this.setAction(this.inGuiActions, this.kbFullmapPanEast, () -> this.getFullscreen().moveCanvas(16, 0));
        this.kbFullmapPanWest = this.register("key.journeymap.fullscreen.west", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 263);
        this.setAction(this.inGuiActions, this.kbFullmapPanWest, () -> this.getFullscreen().moveCanvas(-16, 0));
    }

    private void setAction(ListMultimap<Integer, KeyBindingAction> multimap, KeyBinding keyBinding, Runnable action) {
        multimap.put((Object)keyBinding.getKey().func_197937_c(), (Object)new KeyBindingAction(keyBinding, action));
    }

    private KeyBinding register(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        String category = keyConflictContext == KeyConflictContext.GUI ? Constants.getString("jm.common.hotkeys_keybinding_fullscreen_category") : Constants.getString("jm.common.hotkeys_keybinding_category");
        UpdateAwareKeyBinding kb = new UpdateAwareKeyBinding(description, keyConflictContext, keyModifier, InputMappings.Type.KEYSYM, keyCode, category);
        try {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
        catch (Throwable t) {
            ChatLog.announceError("Unexpected error when registering keybinding : " + (Object)((Object)kb));
        }
        return kb;
    }

    @SubscribeEvent
    public void onGameKeyboardEvent(InputEvent.KeyInputEvent event) {
        int key = event.getKey();
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key)) {
            this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGameActions, key, true, (Event)event);
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        int key = event.getKeyCode();
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key)) {
            if (this.inFullscreenWithoutChat()) {
                this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGuiActions, key, true, (Event)event);
                event.setCanceled(true);
            } else if (this.inMinimapPreview() && this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.minimapPreviewActions, key, false, (Event)event)) {
                ((OptionsManager)this.mc.field_71462_r).refreshMinimapOptions();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseClickedEvent.Post event) {
        int key = event.getButton();
        if (this.inFullscreenWithoutChat()) {
            this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGuiActions, key, true, (Event)event);
        } else if (this.inMinimapPreview() && this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.minimapPreviewActions, key, false, (Event)event)) {
            ((OptionsManager)this.mc.field_71462_r).refreshMinimapOptions();
        }
    }

    public List<KeyBinding> getInGuiKeybindings() {
        List<KeyBinding> list = this.inGuiActions.values().stream().map(KeyBindingAction::getKeyBinding).collect(Collectors.toList());
        list.sort(Comparator.comparing(kb -> Constants.getString(kb.func_151464_g())));
        return list;
    }

    private boolean onInputEvent(Multimap<Integer, KeyBindingAction> multimap, int key, boolean useContext, Event event) {
        try {
            if (this.sortActionsNeeded) {
                this.sortActions();
            }
            for (KeyBindingAction kba : multimap.get((Object)key)) {
                if (!kba.isActive(key, useContext) || Minecraft.func_71410_x().field_71441_e == null) continue;
                this.logger.debug("Firing " + kba);
                kba.getAction().run();
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error checking keybinding", (Object)LogFormatter.toPartialString(e));
        }
        return false;
    }

    private void sortActions() {
        this.sortActions(this.minimapPreviewActions);
        this.sortActions(this.inGameActions);
        this.sortActions(this.inGuiActions);
        this.sortActionsNeeded = false;
    }

    private void sortActions(ListMultimap<Integer, KeyBindingAction> multimap) {
        ArrayList copy = new ArrayList(multimap.values());
        multimap.clear();
        for (KeyBindingAction kba : copy) {
            multimap.put((Object)kba.getKeyBinding().getKey().func_197937_c(), (Object)kba);
        }
        for (Integer key : multimap.keySet()) {
            multimap.get((Object)key).sort(this.kbaComparator);
            Journeymap.getLogger().debug((Object)multimap.get((Object)key));
        }
    }

    private Fullscreen getFullscreen() {
        return UIManager.INSTANCE.openFullscreenMap();
    }

    private boolean inFullscreenWithoutChat() {
        return this.mc.field_71462_r instanceof Fullscreen && !((Fullscreen)this.mc.field_71462_r).isChatOpen();
    }

    private boolean inMinimapPreview() {
        return this.mc.field_71462_r instanceof OptionsManager && ((OptionsManager)this.mc.field_71462_r).previewMiniMap();
    }

    class UpdateAwareKeyBinding
    extends KeyBinding {
        UpdateAwareKeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputMappings.Type inputType, int keyCode, String category) {
            super(description, keyConflictContext, keyModifier, inputType, keyCode, category);
        }

        public void func_197979_b(InputMappings.Input key) {
            super.func_197979_b(key);
            KeyEventHandler.this.sortActionsNeeded = true;
        }

        public void setKeyModifierAndCode(KeyModifier keyModifier, InputMappings.Input keyCode) {
            super.setKeyModifierAndCode(keyModifier, keyCode);
            KeyEventHandler.this.sortActionsNeeded = true;
        }
    }

    static class KeyBindingAction {
        KeyBinding keyBinding;
        Runnable action;

        public KeyBindingAction(KeyBinding keyBinding, Runnable action) {
            this.keyBinding = keyBinding;
            this.action = action;
        }

        boolean isActive(int key, boolean useContext) {
            if (useContext) {
                return this.keyBinding.isActiveAndMatches(InputMappings.Type.KEYSYM.func_197944_a(key));
            }
            return this.keyBinding.getKey().func_197937_c() == key && this.keyBinding.getKeyModifier().isActive(null);
        }

        Runnable getAction() {
            return this.action;
        }

        KeyBinding getKeyBinding() {
            return this.keyBinding;
        }

        int order() {
            return this.keyBinding.getKeyModifier().ordinal();
        }

        public String toString() {
            return "KeyBindingAction{" + this.keyBinding.func_197978_k().toUpperCase() + " = " + Constants.getString(this.keyBinding.func_151464_g()) + '}';
        }
    }
}

