/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.tile;

import com.raoulvdberge.refinedpipes.network.NetworkManager;
import com.raoulvdberge.refinedpipes.network.fluid.FluidNetwork;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.network.pipe.fluid.FluidPipe;
import com.raoulvdberge.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.raoulvdberge.refinedpipes.tile.PipeTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidPipeTileEntity
extends PipeTileEntity {
    private final FluidPipeType type;
    private FluidStack fluid = FluidStack.EMPTY;
    private float fullness = 0.0f;
    private float renderFullness = 0.0f;

    public FluidPipeTileEntity(FluidPipeType type) {
        super(type.getTileType());
        this.type = type;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public float updateAndGetRenderFullness(float partialTicks) {
        float step = partialTicks * 0.05f;
        if (this.renderFullness > this.fullness) {
            this.renderFullness -= step;
            if (this.renderFullness < this.fullness) {
                this.renderFullness = this.fullness;
            }
        } else if (this.renderFullness < this.fullness) {
            this.renderFullness += step;
            if (this.renderFullness > this.fullness) {
                this.renderFullness = this.fullness;
            }
        }
        return this.renderFullness;
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        Pipe pipe = NetworkManager.get(this.field_145850_b).getPipe(this.field_174879_c);
        if (pipe instanceof FluidPipe && pipe.getNetwork() != null) {
            tag.func_218657_a("fluid", (INBT)((FluidNetwork)pipe.getNetwork()).getFluidTank().getFluid().writeToNBT(new CompoundNBT()));
            tag.func_74776_a("fullness", ((FluidPipe)pipe).getFullness());
        }
        return super.writeUpdate(tag);
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        if (tag.func_74764_b("fluid")) {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("fluid"));
        }
        if (tag.func_74764_b("fullness")) {
            this.renderFullness = this.fullness = tag.func_74760_g("fullness");
        }
        super.readUpdate(tag);
    }

    public void setFullness(float fullness) {
        this.fullness = fullness;
    }

    @Override
    protected Pipe createPipe(World world, BlockPos pos) {
        return new FluidPipe(world, pos, this.type);
    }
}

