/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.item;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.api.IShardTier;
import info.tehnut.soulshardsrespawn.api.ISoulShard;
import info.tehnut.soulshardsrespawn.block.TileEntitySoulCage;
import info.tehnut.soulshardsrespawn.core.RegistrarSoulShards;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSoulShard
extends Item
implements ISoulShard {
    private static final Method GET_ENTITY_ID_METHOD = ObfuscationReflectionHelper.findMethod(AbstractSpawner.class, (String)"func_190895_g", (Class[])new Class[0]);

    public ItemSoulShard() {
        super(new Item.Properties().func_200916_a(SoulShards.TAB_SS));
        this.func_185043_a(new ResourceLocation("soulshards", "bound"), (stack, worldIn, entityIn) -> this.getBinding(stack) != null ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("soulshards", "tier"), (stack, world, entity) -> {
            Binding binding = this.getBinding(stack);
            if (binding == null) {
                return 0.0f;
            }
            return Float.parseFloat("0." + Tier.INDEXED.indexOf(binding.getTier()));
        });
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() == null) {
            return ActionResultType.PASS;
        }
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return ActionResultType.PASS;
        }
        if (state.func_177230_c() instanceof SpawnerBlock) {
            if (!SoulShards.CONFIG.getBalance().allowSpawnerAbsorption()) {
                context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("chat.soulshards.absorb_disabled", new Object[0]), true);
                return ActionResultType.PASS;
            }
            if (binding.getKills() >= Tier.maxKills) {
                return ActionResultType.PASS;
            }
            MobSpawnerTileEntity mobSpawner = (MobSpawnerTileEntity)context.func_195991_k().func_175625_s(context.func_195995_a());
            if (mobSpawner == null) {
                return ActionResultType.PASS;
            }
            try {
                ResourceLocation entityId = (ResourceLocation)GET_ENTITY_ID_METHOD.invoke((Object)mobSpawner.func_145881_a(), new Object[0]);
                if (!SoulShards.CONFIG.getEntityList().isEnabled(entityId)) {
                    return ActionResultType.PASS;
                }
                if (entityId == null || binding.getBoundEntity() == null || !binding.getBoundEntity().equals((Object)entityId)) {
                    return ActionResultType.FAIL;
                }
                this.updateBinding(stack, binding.addKills(SoulShards.CONFIG.getBalance().getAbsorptionBonus()));
                context.func_195991_k().func_175655_b(context.func_195995_a(), false);
                return ActionResultType.SUCCESS;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state.func_177230_c() == RegistrarSoulShards.SOUL_CAGE) {
            if (binding.getBoundEntity() == null) {
                return ActionResultType.FAIL;
            }
            TileEntitySoulCage cage = (TileEntitySoulCage)context.func_195991_k().func_175625_s(context.func_195995_a());
            if (cage == null) {
                return ActionResultType.PASS;
            }
            ItemStackHandler itemHandler = cage.getInventory();
            if (itemHandler != null && itemHandler.getStackInSlot(0).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.func_77946_l(), (boolean)false);
                cage.func_70296_d();
                cage.setState(true);
                context.func_195999_j().func_184611_a(context.func_221531_n(), ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        items.add((Object)new ItemStack((IItemProvider)this));
        for (IShardTier tier : Tier.INDEXED) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            Binding binding = new Binding(null, tier.getKillRequirement());
            this.updateBinding(stack, binding);
            items.add((Object)stack);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        EntityType entityEntry;
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return;
        }
        if (binding.getBoundEntity() != null && (entityEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(binding.getBoundEntity())) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.soulshards.bound", new Object[]{entityEntry.func_212546_e()}));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.soulshards.tier", new Object[]{binding.getTier().getIndex()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.soulshards.kills", new Object[]{binding.getKills()}));
        if (flag.func_194127_a() && binding.getOwner() != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.soulshards.owner", new Object[]{binding.getOwner().toString()}));
        }
    }

    public String func_77667_c(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return super.func_77667_c(stack) + (binding == null || binding.getBoundEntity() == null ? "_unbound" : "");
    }

    public boolean func_77636_d(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return binding != null && binding.getKills() >= Tier.maxKills;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return SoulShards.CONFIG.getClient().displayDurabilityBar() && binding != null && binding.getKills() < Tier.maxKills;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return 1.0;
        }
        return 1.0 - (double)binding.getKills() / (double)Tier.maxKills;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return super.getRGBDurabilityForDisplay(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getBinding(stack) == null ? 64 : 1;
    }

    @Override
    @Nullable
    public Binding getBinding(ItemStack stack) {
        return Binding.fromNBT(stack);
    }

    public void updateBinding(ItemStack stack, Binding binding) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_218657_a("binding", (INBT)binding.serializeNBT());
    }
}

