/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.blocks.tube;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.util.Direction;

public class ItemInTubeWrapper {
    public ItemStack stack;
    public LinkedList<Direction> remainingMoves;
    public int maximumDurationInTube;
    public int ticksElapsed;
    public boolean freshlyInserted = false;
    public static final String MOVES_REMAINING_TAG = "moves";
    public static final String TICKS_REMAINING_TAG = "ticksRemaining";
    public static final String TICKS_DURATION_TAG = "maxDurationInTicks";
    public static final String IS_FRESHLY_INSERTED = "isFreshly";

    public ItemInTubeWrapper(ItemStack stack, Queue<Direction> moves, int ticksToTravel) {
        this.stack = stack.func_77946_l();
        this.remainingMoves = new LinkedList();
        for (Direction dir : moves) {
            this.remainingMoves.add(dir);
        }
        this.ticksElapsed = 0;
        this.maximumDurationInTube = ticksToTravel;
    }

    public ItemInTubeWrapper(ItemStack stack, Queue<Direction> moves, int ticksToTravel, Direction firstMove) {
        this(stack, moves, ticksToTravel);
        if (firstMove != null) {
            this.remainingMoves.addFirst(firstMove);
            this.freshlyInserted = true;
        }
    }

    public static ItemInTubeWrapper readFromNBT(CompoundNBT compound) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compound);
        int[] moveBuffer = compound.func_74759_k(MOVES_REMAINING_TAG);
        int ticksElapsed = compound.func_74762_e(TICKS_REMAINING_TAG);
        int maxDuration = compound.func_74762_e(TICKS_DURATION_TAG);
        boolean isFreshlyInserted = compound.func_74767_n(IS_FRESHLY_INSERTED);
        ItemInTubeWrapper wrapper = new ItemInTubeWrapper(stack, ItemInTubeWrapper.decompressMoveList(moveBuffer), maxDuration);
        wrapper.ticksElapsed = ticksElapsed;
        wrapper.freshlyInserted = isFreshlyInserted;
        return wrapper;
    }

    public CompoundNBT writeToNBT(CompoundNBT compound) {
        compound.func_218657_a(MOVES_REMAINING_TAG, (INBT)ItemInTubeWrapper.compressMoveList(this.remainingMoves));
        compound.func_74768_a(TICKS_REMAINING_TAG, this.ticksElapsed);
        compound.func_74768_a(TICKS_DURATION_TAG, this.maximumDurationInTube);
        compound.func_74757_a(IS_FRESHLY_INSERTED, this.freshlyInserted);
        this.stack.func_77955_b(compound);
        return compound;
    }

    public static IntArrayNBT compressMoveList(Queue<Direction> moves) {
        if (moves == null || moves.isEmpty()) {
            return new IntArrayNBT(new int[0]);
        }
        int moveIndex = 0;
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        Direction currentMove = moves.peek();
        buffer.add(currentMove.func_176745_a());
        buffer.add(0);
        for (Direction dir : moves) {
            if (!dir.equals((Object)currentMove)) {
                buffer.add(dir.func_176745_a());
                buffer.add(1);
                currentMove = dir;
                moveIndex += 2;
                continue;
            }
            buffer.set(moveIndex + 1, (Integer)buffer.get(moveIndex + 1) + 1);
        }
        IntArrayNBT nbt = new IntArrayNBT(buffer);
        return nbt;
    }

    public static Queue<Direction> decompressMoveList(int[] buffer) {
        LinkedList<Direction> moves = new LinkedList<Direction>();
        int size = buffer.length;
        if (size % 2 != 0) {
            return moves;
        }
        int pairCount = size / 2;
        for (int i = 0; i < pairCount; ++i) {
            Direction dir = Direction.func_82600_a((int)buffer[i * 2]);
            int moveCount = buffer[i * 2 + 1];
            for (int count = 0; count < moveCount; ++count) {
                moves.add(dir);
            }
        }
        return moves;
    }
}

