/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.container;

import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import tk.zeitheron.solarflux.SolarFlux;
import tk.zeitheron.solarflux.block.SolarPanelTile;
import tk.zeitheron.solarflux.container.SlotChargable;
import tk.zeitheron.solarflux.container.SlotUpgrade;
import tk.zeitheron.solarflux.util.ComplexProgressManager;

public class SolarPanelContainer
extends Container {
    public final SolarPanelTile panel;
    public final ComplexProgressManager progressHandler = new ComplexProgressManager(36, 0);

    public SolarPanelContainer(int id, PlayerInventory playerInv, SolarPanelTile tile) {
        super(SolarFlux.SOLAR_PANEL_CONTAINER, id);
        this.panel = tile;
        this.addPlayerInventorySlotsToContainer(playerInv, 8, 98);
        this.addPlayerActionSlotsToContainer(playerInv, 8, 156);
        for (int i = 0; i < tile.upgradeInventory.getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotUpgrade(tile, i, i * 18 + 9, 61));
        }
        this.func_75146_a((Slot)new SlotChargable(tile.chargeInventory, 0, 151, 9));
    }

    protected void addPlayerInventorySlotsToContainer(PlayerInventory pInventoryPlayer, int pLeft, int pTop) {
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)pInventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, pLeft + inventoryColumnIndex * 18, pTop + inventoryRowIndex * 18));
            }
        }
    }

    protected void addPlayerActionSlotsToContainer(PlayerInventory player, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player, i, x + i * 18, y));
        }
    }

    public void func_75142_b() {
        this.progressHandler.putLong(0, this.panel.energy);
        this.progressHandler.putLong(8, this.panel.capacity.getValueL());
        this.progressHandler.putLong(16, this.panel.currentGeneration);
        this.progressHandler.putLong(24, this.panel.generation.getValueL());
        this.progressHandler.putFloat(32, this.panel.sunIntensity);
        super.func_75142_b();
        this.progressHandler.detectAndSendChanges(this);
    }

    public void func_75137_b(int id, int data) {
        this.progressHandler.updateChange(id, data);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.panel.func_174877_v().func_218138_a((IPosition)playerIn.func_174791_d(), true) <= 64.0;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return ItemStack.field_190927_a;
    }
}

