/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dimensionalworld.block;

import com.buuz135.dimensionalworld.block.tile.DimensionalLeverTile;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;

public class DimensionalLever
extends Block
implements ITileEntityProvider {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape LEVER_NORTH_AABB = Block.func_208617_a((double)5.0, (double)4.0, (double)10.0, (double)11.0, (double)12.0, (double)16.0);
    protected static final VoxelShape LEVER_SOUTH_AABB = Block.func_208617_a((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)6.0);
    protected static final VoxelShape LEVER_WEST_AABB = Block.func_208617_a((double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    protected static final VoxelShape LEVER_EAST_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)11.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)6.0, (double)12.0);
    protected static final VoxelShape FLOOR_X_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)6.0, (double)11.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.func_208617_a((double)5.0, (double)10.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    protected static final VoxelShape CEILING_X_SHAPE = Block.func_208617_a((double)4.0, (double)10.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
    private final ResourceLocation dimension;

    public DimensionalLever(ResourceLocation dimension) {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)AttachFace.WALL));
        this.dimension = dimension;
        this.setRegistryName("dimensionalworld", dimension.func_110623_a() + "_lever");
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState blockState = this.cycle(state, worldIn, pos);
        float f = (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof DimensionalLeverTile) {
            Optional type = Registry.field_212622_k.func_218349_b(((DimensionalLeverTile)tileEntity).getDestinationType() != null ? ((DimensionalLeverTile)tileEntity).getDestinationType() : this.getDestination(worldIn));
            BlockPos destination = ((DimensionalLeverTile)tileEntity).getDestination();
            if (player != null && type.isPresent()) {
                ServerWorld destinationWorld = DimensionManager.getWorld((MinecraftServer)player.func_184102_h(), (DimensionType)((DimensionType)type.get()), (boolean)true, (boolean)true);
                if (destination == null || destinationWorld.func_180495_p(destination).func_177230_c() != this) {
                    destination = new BlockPos(pos.func_177958_n(), destinationWorld.func_217349_x(pos).func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.func_177958_n(), pos.func_177952_p()) + 1, pos.func_177952_p());
                    destinationWorld.func_175656_a(destination, (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)AttachFace.FLOOR));
                    TileEntity destinationTile = destinationWorld.func_175625_s(destination);
                    if (destinationTile instanceof DimensionalLeverTile) {
                        ((DimensionalLeverTile)destinationTile).setDestination(pos);
                        ((DimensionalLeverTile)destinationTile).setDestinationType(worldIn.func_201675_m().func_186058_p().getRegistryName());
                    }
                    ((DimensionalLeverTile)tileEntity).setDestination(destination);
                }
                final BlockPos finalDestination = destination;
                player.changeDimension((DimensionType)type.get(), new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity repositionedEntity = repositionEntity.apply(false);
                        repositionedEntity.func_70634_a((double)finalDestination.func_177958_n() + 0.5, (double)finalDestination.func_177956_o() + 0.5, (double)finalDestination.func_177952_p() + 0.5);
                        return repositionedEntity;
                    }
                });
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ResourceLocation getDestination(World world) {
        if (world.func_201675_m().func_186058_p().getRegistryName().equals((Object)this.dimension)) {
            return DimensionType.field_223227_a_.getRegistryName();
        }
        return this.dimension;
    }

    public BlockState cycle(BlockState p_226939_1_, World p_226939_2_, BlockPos p_226939_3_) {
        p_226939_1_ = (BlockState)p_226939_1_.func_177231_a((IProperty)POWERED);
        p_226939_2_.func_180501_a(p_226939_3_, p_226939_1_, 3);
        return p_226939_1_;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208158_K, BlockStateProperties.field_208157_J, POWERED});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new DimensionalLeverTile();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((IProperty)BlockStateProperties.field_208158_K)) {
            case FLOOR: {
                switch (((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k()) {
                    case X: {
                        return FLOOR_X_SHAPE;
                    }
                }
                return FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)) {
                    case EAST: {
                        return LEVER_EAST_AABB;
                    }
                    case WEST: {
                        return LEVER_WEST_AABB;
                    }
                    case SOUTH: {
                        return LEVER_SOUTH_AABB;
                    }
                }
                return LEVER_NORTH_AABB;
            }
        }
        switch (((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k()) {
            case X: {
                return CEILING_X_SHAPE;
            }
        }
        return CEILING_Z_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = direction.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)AttachFace.WALL)).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)direction.func_176734_d());
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return blockstate;
        }
        return null;
    }
}

