/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigBoolean;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigDouble;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigEnum;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigInt;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigItemStack;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigList;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigLong;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class ConfigGroup {
    public final String id;
    public ConfigGroup parent;
    private final Map<String, ConfigValue> values;
    private final Map<String, ConfigGroup> groups;
    public ConfigCallback savedCallback;
    private String nameKey;

    public ConfigGroup(String i) {
        this.id = i;
        this.values = new LinkedHashMap<String, ConfigValue>();
        this.groups = new LinkedHashMap<String, ConfigGroup>();
        this.savedCallback = null;
        this.nameKey = "";
    }

    public String getNameKey() {
        return this.nameKey.isEmpty() ? this.getPath() : this.nameKey;
    }

    public ConfigGroup setNameKey(String key) {
        this.nameKey = key;
        return this;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.getNameKey(), (Object[])new Object[0]);
    }

    public String getTooltip() {
        String t = this.getNameKey() + ".tooltip";
        return I18n.func_188566_a((String)t) ? I18n.func_135052_a((String)t, (Object[])new Object[0]) : "";
    }

    public ConfigGroup getGroup(String id) {
        int index = id.indexOf(46);
        if (index == -1) {
            ConfigGroup g = this.groups.get(id);
            if (g == null) {
                g = new ConfigGroup(id);
                g.parent = this;
                this.groups.put(g.id, g);
            }
            return g;
        }
        return this.getGroup(id.substring(0, index)).getGroup(id.substring(index + 1));
    }

    public <T, CV extends ConfigValue<T>> CV add(String id, CV type, @Nullable T value, Consumer<T> callback, @Nullable T defaultValue) {
        type.init(this, id, value, callback, defaultValue);
        this.values.put(id, type);
        return type;
    }

    public ConfigBoolean addBool(String id, boolean value, Consumer<Boolean> setter, boolean def) {
        return this.add(id, new ConfigBoolean(), value, setter, def);
    }

    public ConfigInt addInt(String id, int value, Consumer<Integer> setter, int def, int min, int max) {
        return this.add(id, new ConfigInt(min, max), value, setter, def);
    }

    public ConfigLong addLong(String id, long value, Consumer<Long> setter, long def, long min, long max) {
        return this.add(id, new ConfigLong(min, max), value, setter, def);
    }

    public ConfigDouble addDouble(String id, double value, Consumer<Double> setter, double def, double min, double max) {
        return this.add(id, new ConfigDouble(min, max), value, setter, def);
    }

    public ConfigString addString(String id, String value, Consumer<String> setter, String def, @Nullable Pattern pattern) {
        return this.add(id, new ConfigString(pattern), value, setter, def);
    }

    public ConfigString addString(String id, String value, Consumer<String> setter, String def) {
        return this.addString(id, value, setter, def, null);
    }

    public <E> ConfigEnum<E> addEnum(String id, E value, Consumer<E> setter, NameMap<E> nameMap, E def) {
        return this.add(id, new ConfigEnum<E>(nameMap), value, setter, def);
    }

    public <E> ConfigEnum<E> addEnum(String id, E value, Consumer<E> setter, NameMap<E> nameMap) {
        return this.addEnum(id, value, setter, nameMap, nameMap.defaultValue);
    }

    public <E, CV extends ConfigValue<E>> ConfigList<E, CV> addList(String id, List<E> c, CV type, E def) {
        type.defaultValue = def;
        return this.add(id, new ConfigList(type), c, t -> {
            c.clear();
            c.addAll((Collection)t);
        }, Collections.emptyList());
    }

    public ConfigEnum<Tristate> addTristate(String id, Tristate value, Consumer<Tristate> setter, Tristate def) {
        return this.addEnum(id, value, setter, Tristate.NAME_MAP, def);
    }

    public ConfigEnum<Tristate> addTristate(String id, Tristate value, Consumer<Tristate> setter) {
        return this.addTristate(id, value, setter, Tristate.DEFAULT);
    }

    public ConfigItemStack addItemStack(String id, ItemStack value, Consumer<ItemStack> setter, ItemStack def, boolean singleItemOnly, boolean allowEmpty) {
        return this.add(id, new ConfigItemStack(singleItemOnly, allowEmpty), value, setter, def);
    }

    public final Collection<ConfigValue> getValues() {
        return this.values.values();
    }

    public final Collection<ConfigGroup> getGroups() {
        return this.groups.values();
    }

    public String getPath() {
        if (this.parent == null) {
            return this.id;
        }
        return this.parent.getPath() + '.' + this.id;
    }

    public void save(boolean accepted) {
        if (accepted) {
            for (ConfigValue value : this.values.values()) {
                value.setter.accept(value.value);
            }
        }
        for (ConfigGroup group : this.groups.values()) {
            group.save(accepted);
        }
        if (this.savedCallback != null) {
            this.savedCallback.save(accepted);
        }
    }
}

