/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.ItemUseContextAccess;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class RatAIHarvestFarmer
extends Goal {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;

    public RatAIHarvestFarmer(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.entity.getCommand() == RatCommand.HARVEST && !this.entity.isInCage() && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && (this.holdingSeeds() || this.holdingBlock() || this.holdingBonemeal()))) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private boolean holdingSeeds() {
        return !this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof BlockNamedItem;
    }

    private boolean holdingBonemeal() {
        ItemStack stack = this.entity.func_184586_b(Hand.MAIN_HAND);
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_196106_bc;
    }

    private boolean holdingBlock() {
        return !this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof BlockItem;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && (this.holdingSeeds() || this.holdingBonemeal() || this.holdingBlock());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_75246_d() {
        double distance;
        BlockState block;
        if (this.targetBlock == null) return;
        if (this.holdingSeeds()) {
            block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25);
            if (block.func_177230_c().isFertile(block, (IBlockReader)this.entity.field_70170_p, this.targetBlock) && this.entity.field_70170_p.func_175623_d(this.targetBlock.func_177984_a())) {
                distance = this.entity.func_70092_e(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 4.5 * this.entity.getRatDistanceModifier()) {
                    if (this.holdingSeeds()) {
                        ItemStack seedStack = this.entity.func_184586_b(Hand.MAIN_HAND).func_77946_l();
                        seedStack.func_190920_e(1);
                        this.entity.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                        if (seedStack.func_77973_b() instanceof BlockNamedItem) {
                            this.entity.field_70170_p.func_175656_a(this.targetBlock.func_177984_a(), ((BlockNamedItem)seedStack.func_77973_b()).func_179223_d().func_176223_P());
                        }
                    }
                    this.targetBlock = null;
                    this.func_75251_c();
                    return;
                }
            } else {
                this.targetBlock = null;
                this.func_75251_c();
                return;
            }
        }
        if (this.holdingBonemeal()) {
            block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25);
            if (this.canPlantBeBonemealed(this.targetBlock, block)) {
                distance = this.entity.func_70092_e(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (!(distance < 4.5)) return;
                if (this.holdingBonemeal()) {
                    IGrowable igrowable;
                    this.entity.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                    if (block.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)block.func_177230_c()).func_176473_a((IBlockReader)this.entity.field_70170_p, this.targetBlock, block, this.entity.field_70170_p.field_72995_K) && !this.entity.field_70170_p.field_72995_K) {
                        this.entity.field_70170_p.func_217379_c(2005, this.targetBlock, 0);
                        igrowable.func_225535_a_((ServerWorld)this.entity.field_70170_p, this.entity.field_70170_p.field_73012_v, this.targetBlock, block);
                    }
                }
                this.targetBlock = null;
                this.func_75251_c();
                return;
            }
            this.targetBlock = null;
            this.func_75251_c();
            return;
        }
        if (!this.holdingBlock()) return;
        BlockItem itemBlock = (BlockItem)this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b();
        this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25);
        if (this.entity.field_70170_p.func_175623_d(this.targetBlock.func_177984_a())) {
            distance = this.entity.func_70092_e(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
            if (!(distance < 4.5)) return;
            if (this.holdingBlock()) {
                BlockRayTraceResult raytrace = this.entity.field_70170_p.func_217299_a(new RayTraceContext(new Vec3d((Vec3i)this.targetBlock), new Vec3d((Vec3i)this.targetBlock), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity));
                ItemUseContextAccess itemusecontext = new ItemUseContextAccess(this.entity.field_70170_p, null, Hand.MAIN_HAND, this.entity.func_184586_b(Hand.MAIN_HAND), raytrace);
                BlockState BlockState1 = itemBlock.func_179223_d().func_196258_a(new BlockItemUseContext((ItemUseContext)itemusecontext));
                this.entity.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                this.entity.field_70170_p.func_175656_a(this.targetBlock, BlockState1);
                if (this.entity.func_70094_T()) {
                    this.entity.func_70107_b(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() + 1.0, this.entity.func_226281_cx_());
                }
                SoundType placeSound = BlockState1.func_177230_c().getSoundType(BlockState1, (IWorldReader)this.entity.field_70170_p, this.targetBlock, (Entity)this.entity);
                this.entity.func_184185_a(placeSound.func_185841_e(), (placeSound.func_185843_a() + 1.0f) / 2.0f, placeSound.func_185847_b() * 0.8f);
            }
            this.targetBlock = null;
            this.func_75251_c();
            return;
        }
        this.targetBlock = null;
        this.func_75251_c();
    }

    private void resetTarget() {
        int RADIUS = this.entity.getSearchRadius();
        if (this.holdingBonemeal()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (!this.canPlantBeBonemealed(pos, this.entity.field_70170_p.func_180495_p(pos))) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(0);
            }
        } else if (this.holdingSeeds()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (!this.entity.field_70170_p.func_180495_p(pos).func_177230_c().isFertile(this.entity.field_70170_p.func_180495_p(pos), (IBlockReader)this.entity.field_70170_p, pos) || !this.entity.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(0);
            }
        } else if (this.holdingBlock()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            Block block = Blocks.field_196674_t;
            if (this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof BlockItem) {
                block = ((BlockItem)this.entity.func_184586_b(Hand.MAIN_HAND).func_77973_b()).func_179223_d();
            }
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (!block.getBlock().func_196260_a(block.func_176223_P(), (IWorldReader)this.entity.field_70170_p, pos) || !this.entity.field_70170_p.func_175623_d(pos.func_177984_a()) || !this.entity.field_70170_p.func_175623_d(pos)) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(0);
            }
        }
    }

    private boolean canPlantBeBonemealed(BlockPos pos, BlockState BlockState2) {
        IGrowable igrowable;
        if (BlockState2.func_177230_c() instanceof IGrowable && !(BlockState2.func_177230_c() instanceof TallGrassBlock) && !(BlockState2.func_177230_c() instanceof GrassBlock) && (igrowable = (IGrowable)BlockState2.func_177230_c()).func_176473_a((IBlockReader)this.entity.field_70170_p, pos, BlockState2, this.entity.field_70170_p.field_72995_K) && !this.entity.field_70170_p.field_72995_K) {
            return igrowable.func_180670_a(this.entity.field_70170_p, this.entity.field_70170_p.field_73012_v, pos, BlockState2);
        }
        return false;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

