/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityPirat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PiratAIWander
extends Goal {
    private EntityPirat rat;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private double speed;
    private int executionChance;
    private boolean mustUpdate;

    public PiratAIWander(EntityPirat creatureIn, double speedIn) {
        this(creatureIn, speedIn, 20);
    }

    public PiratAIWander(EntityPirat creatureIn, double speedIn, int chance) {
        this.rat = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.mustUpdate && this.rat.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3d vec3d = RatUtils.generateRandomWaterPos((CreatureEntity)this.rat, 10, 5, null, true);
        if (vec3d == null) {
            return false;
        }
        BlockPos water = RatUtils.findLowestWater(new BlockPos(vec3d), (CreatureEntity)this.rat);
        this.xPosition = water.func_177958_n();
        this.yPosition = water.func_177956_o();
        this.zPosition = water.func_177952_p();
        this.mustUpdate = false;
        return true;
    }

    public boolean func_75253_b() {
        return !this.rat.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.rat.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

