/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;

public class RatUtils {
    public static final Predicate<Entity> UNTAMED_RAT_SELECTOR = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityRat && !((EntityRat)p_apply_1_).func_70909_n();
        }
    };
    public static final ResourceLocation PIRAT_ONLY_BLOCKS = new ResourceLocation("rats", "pirat_blocks");
    public static final ResourceLocation SEED_ITEMS = new ResourceLocation("forge", "seeds");
    public static final ResourceLocation CHEESE_ITEMS = new ResourceLocation("forge", "cheese");

    public static boolean isMilk(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151117_aB) {
            return true;
        }
        LazyOptional fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack.orElse(null) != null && ((FluidStack)fluidStack.orElse(null)).getAmount() >= 1000 && (((FluidStack)fluidStack.orElse(null)).getFluid().getRegistryName().func_110623_a().contains("milk") || ((FluidStack)fluidStack.orElse(null)).getFluid().getRegistryName().func_110623_a().contains("Milk"));
    }

    public static boolean isRatFood(ItemStack stack) {
        return (stack.func_77973_b().func_219971_r() || RatUtils.isSeeds(stack) || stack.func_77973_b() == Items.field_151015_O) && stack.func_77973_b() != RatsItemRegistry.RAW_RAT && stack.func_77973_b() != RatsItemRegistry.COOKED_RAT;
    }

    public static boolean shouldRaidItem(ItemStack stack) {
        return RatUtils.isRatFood(stack) && stack.func_77973_b() != RatsItemRegistry.CONTAMINATED_FOOD;
    }

    public static boolean isSeeds(ItemStack stack) {
        Item item = stack.func_77973_b();
        return ItemTags.func_199903_a().func_199915_b(SEED_ITEMS).func_199685_a_((Object)item);
    }

    public static boolean doesContainFood(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!RatUtils.isRatFood(inventory.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getFoodFromInventory(EntityRat rat, IInventory inventory, Random random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!RatUtils.shouldRaidItem(stack) || !rat.canRatPickupItem(stack)) continue;
            items.add(stack);
        }
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (items.size() == 1) {
            return (ItemStack)items.get(0);
        }
        return (ItemStack)items.get(random.nextInt(items.size() - 1));
    }

    public static int getContaminatedSlot(EntityRat rat, IInventory inventory, Random random) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() != RatsItemRegistry.CONTAMINATED_FOOD) continue;
            items.add(i);
        }
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return (Integer)items.get(0);
        }
        return (Integer)items.get(random.nextInt(items.size() - 1));
    }

    public static int getItemSlotFromItemHandler(EntityRat rat, IItemHandler handler, Random random) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        if (handler == null) {
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, handler.getSlotLimit(i), true);
            if (!rat.canRatPickupItem(stack)) continue;
            items.add(i);
        }
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return (Integer)items.get(0);
        }
        return (Integer)items.get(random.nextInt(items.size()));
    }

    public static boolean isItemHandlerFull(IItemHandler handler, ItemStack mergeStack) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (!itemstack.func_190926_b() && (mergeStack == null || mergeStack.func_190926_b() || !itemstack.func_77969_a(mergeStack) || itemstack.func_190916_E() + mergeStack.func_190916_E() >= itemstack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRatHoleInBoundingBox(AxisAlignedBB bb, World world) {
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.Mutable blockpos$pooledmutableblockpos = new BlockPos.Mutable();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    BlockState BlockState1 = world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(l3, i4, j4));
                    if (BlockState1.func_177230_c() != RatsBlockRegistry.RAT_HOLE && BlockState1.func_177230_c() != RatsBlockRegistry.RAT_CAGE) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksIgnoreRatholes(World world, Vec3d start, Vec3d end, boolean stopOnLiquid, Entity entity) {
        return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksIgnoreRatholes(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                BlockState BlockState2 = world.func_180495_p(blockpos);
                Block block = BlockState2.func_177230_c();
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    Direction Direction2;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        Direction2 = i > l ? Direction.WEST : Direction.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        Direction2 = j > i1 ? Direction.DOWN : Direction.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        Direction2 = k > j1 ? Direction.NORTH : Direction.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (Direction2 == Direction.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (Direction2 == Direction.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (Direction2 == Direction.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    BlockState BlockState1 = world.func_180495_p(blockpos);
                    Block block2 = BlockState1.func_177230_c();
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public static boolean isPredator(Entity entity) {
        return entity instanceof OcelotEntity || entity instanceof CatEntity || entity instanceof FoxEntity;
    }

    public static RatCommand wrapCommand(int newCommand) {
        int length = RatCommand.values().length;
        if (newCommand >= length) {
            newCommand = 0;
        }
        if (newCommand < 0) {
            newCommand = length - 1;
        }
        return RatCommand.values()[newCommand];
    }

    public static boolean isCheese(ItemStack cheese) {
        return ItemTags.func_199903_a().func_199915_b(CHEESE_ITEMS).func_199685_a_((Object)cheese.func_77973_b());
    }

    @Nullable
    public static Vec3d findRandomCageOrTubeTarget(EntityRat rat, int xz, int y) {
        return RatUtils.generateRandomCageOrTubePos(rat, xz, y, null, false);
    }

    @Nullable
    public static Vec3d generateRandomCageOrTubePos(EntityRat rat, int searchWidth, int searchHeight, @Nullable Vec3d positionVector, boolean water) {
        double d1;
        double d0;
        PathNavigator pathnavigate = rat.func_70661_as();
        Random random = rat.func_70681_au();
        boolean flag = rat.func_213394_dL() ? (d0 = rat.func_213384_dI().func_218140_a((double)MathHelper.func_76128_c((double)rat.func_226277_ct_()), (double)MathHelper.func_76128_c((double)rat.func_226278_cu_()), (double)MathHelper.func_76128_c((double)rat.func_226281_cx_()), true) + 4.0) < (d1 = (double)(rat.func_213391_dJ() + (float)searchWidth)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * searchWidth + 1) - searchWidth;
            int i1 = random.nextInt(2 * searchHeight + 1) - searchHeight;
            int j1 = random.nextInt(2 * searchWidth + 1) - searchWidth;
            if (positionVector != null && !((double)l * positionVector.field_72450_a + (double)j1 * positionVector.field_72449_c >= 0.0)) continue;
            if (rat.func_213394_dL() && searchWidth > 1) {
                BlockPos blockpos = rat.func_213384_dI();
                l = rat.func_226277_ct_() > (double)blockpos.func_177958_n() ? (l -= random.nextInt(searchWidth / 2)) : (l += random.nextInt(searchWidth / 2));
                j1 = rat.func_226281_cx_() > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(searchWidth / 2)) : (j1 += random.nextInt(searchWidth / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + rat.func_226277_ct_(), (double)i1 + rat.func_226278_cu_(), (double)j1 + rat.func_226281_cx_());
            if (flag && !rat.func_213389_a(blockpos1) || rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() != RatsBlockRegistry.RAT_CAGE && !(rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() instanceof BlockRatTube) || !((f1 = rat.func_180484_a(blockpos1 = RatUtils.findLowestRatCage(blockpos1, (CreatureEntity)rat))) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + rat.func_226277_ct_(), (double)i + rat.func_226278_cu_(), (double)j + rat.func_226281_cx_());
        }
        return null;
    }

    @Nullable
    public static Vec3d generateRandomCagePos(EntityRat rat, int searchWidth, int searchHeight, @Nullable Vec3d positionVector, boolean water) {
        double d1;
        double d0;
        PathNavigator pathnavigate = rat.func_70661_as();
        Random random = rat.func_70681_au();
        boolean flag = rat.func_213394_dL() ? (d0 = rat.func_213384_dI().func_218140_a((double)MathHelper.func_76128_c((double)rat.func_226277_ct_()), (double)MathHelper.func_76128_c((double)rat.func_226278_cu_()), (double)MathHelper.func_76128_c((double)rat.func_226281_cx_()), true) + 4.0) < (d1 = (double)(rat.func_213391_dJ() + (float)searchWidth)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * searchWidth + 1) - searchWidth;
            int i1 = random.nextInt(2 * searchHeight + 1) - searchHeight;
            int j1 = random.nextInt(2 * searchWidth + 1) - searchWidth;
            if (positionVector != null && !((double)l * positionVector.field_72450_a + (double)j1 * positionVector.field_72449_c >= 0.0)) continue;
            if (rat.func_213394_dL() && searchWidth > 1) {
                BlockPos blockpos = rat.func_213384_dI();
                l = rat.func_226277_ct_() > (double)blockpos.func_177958_n() ? (l -= random.nextInt(searchWidth / 2)) : (l += random.nextInt(searchWidth / 2));
                j1 = rat.func_226281_cx_() > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(searchWidth / 2)) : (j1 += random.nextInt(searchWidth / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + rat.func_226277_ct_(), (double)i1 + rat.func_226278_cu_(), (double)j1 + rat.func_226281_cx_());
            if (flag && !rat.func_213389_a(blockpos1) || rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() != RatsBlockRegistry.RAT_CAGE || !((f1 = rat.func_180484_a(blockpos1 = RatUtils.findLowestRatCage(blockpos1, (CreatureEntity)rat))) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + rat.func_226277_ct_(), (double)i + rat.func_226278_cu_(), (double)j + rat.func_226281_cx_());
        }
        return null;
    }

    @Nullable
    public static Vec3d generateRandomTubePos(EntityRat rat, int searchWidth, int searchHeight, @Nullable Vec3d positionVector, boolean water) {
        double d1;
        double d0;
        PathNavigator pathnavigate = rat.func_70661_as();
        Random random = rat.func_70681_au();
        boolean flag = rat.func_213394_dL() ? (d0 = rat.func_213384_dI().func_218140_a((double)MathHelper.func_76128_c((double)rat.func_226277_ct_()), (double)MathHelper.func_76128_c((double)rat.func_226278_cu_()), (double)MathHelper.func_76128_c((double)rat.func_226281_cx_()), true) + 4.0) < (d1 = (double)(rat.func_213391_dJ() + (float)searchWidth)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * searchWidth + 1) - searchWidth;
            int i1 = random.nextInt(2 * searchHeight + 1) - searchHeight;
            int j1 = random.nextInt(2 * searchWidth + 1) - searchWidth;
            if (positionVector != null && !((double)l * positionVector.field_72450_a + (double)j1 * positionVector.field_72449_c >= 0.0)) continue;
            if (rat.func_213394_dL() && searchWidth > 1) {
                BlockPos blockpos = rat.func_213384_dI();
                l = rat.func_226277_ct_() > (double)blockpos.func_177958_n() ? (l -= random.nextInt(searchWidth / 2)) : (l += random.nextInt(searchWidth / 2));
                j1 = rat.func_226281_cx_() > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(searchWidth / 2)) : (j1 += random.nextInt(searchWidth / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + rat.func_226277_ct_(), (double)i1 + rat.func_226278_cu_(), (double)j1 + rat.func_226281_cx_());
            if (flag && !rat.func_213389_a(blockpos1) || !(rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() instanceof BlockRatTube) || !((f1 = rat.func_180484_a(blockpos1 = RatUtils.findLowestRatCage(blockpos1, (CreatureEntity)rat))) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + rat.func_226277_ct_(), (double)i + rat.func_226278_cu_(), (double)j + rat.func_226281_cx_());
        }
        return null;
    }

    public static BlockPos findLowestRatCage(BlockPos pos, CreatureEntity rat) {
        if (rat.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() != RatsBlockRegistry.RAT_CAGE && !(rat.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRatTube)) {
            return pos;
        }
        BlockPos blockpos = pos.func_177977_b();
        while (blockpos.func_177956_o() > 0 && rat.field_70170_p.func_180495_p(blockpos).func_177230_c() != RatsBlockRegistry.RAT_CAGE && !(rat.field_70170_p.func_180495_p(blockpos).func_177230_c() instanceof BlockRatTube)) {
            blockpos = blockpos.func_177977_b();
        }
        return blockpos;
    }

    public static BlockPos findLowestWater(BlockPos pos, CreatureEntity rat) {
        if (rat.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            return pos;
        }
        BlockPos blockpos = pos.func_177977_b();
        while (blockpos.func_177956_o() > 0 && rat.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151586_h) {
            blockpos = blockpos.func_177977_b();
        }
        return blockpos;
    }

    public static boolean canRatBreakBlock(World world, BlockPos pos, EntityRat rat) {
        BlockState blockState = world.func_180495_p(pos);
        float hardness = blockState.func_185887_b((IBlockReader)world, pos);
        return hardness != -1.0f && hardness <= RatConfig.ratStrengthThreshold && blockState.func_177230_c().canEntityDestroy(blockState, (IBlockReader)world, pos, (Entity)rat) && WitherEntity.func_181033_a((BlockState)blockState);
    }

    public static boolean isRatTube(IWorldReader world, BlockPos offset) {
        return world.func_175625_s(offset) instanceof TileEntityRatTube;
    }

    public static boolean isConnectedToRatTube(IWorldReader world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            for (Direction facing : Direction.values()) {
                if (!RatUtils.isRatTube(world, pos.func_177972_a(facing))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenRatTube(IBlockReader world, EntityRat rat, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRatTube) {
            for (int i = 0; i < Direction.values().length; ++i) {
                BooleanProperty bool = BlockRatTube.ALL_OPEN_PROPS[i];
                if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue() || rat == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLinkedToTube(IWorldReader world, BlockPos offset) {
        return RatUtils.isRatTube(world, offset) || RatUtils.isConnectedToRatTube(world, offset);
    }

    public static BlockPos offsetTubeEntrance(IWorldReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRatTube) {
            for (int i = 0; i < Direction.values().length; ++i) {
                BooleanProperty bool = BlockRatTube.ALL_OPEN_PROPS[i];
                if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue()) continue;
                return pos.func_177972_a(Direction.values()[i]);
            }
        }
        return pos;
    }

    public static Vec3d generateRandomWaterPos(CreatureEntity p_191379_0_, int p_191379_1_, int p_191379_2_, @Nullable Vec3d p_191379_3_, boolean p_191379_4_) {
        double d1;
        double d0;
        PathNavigator pathnavigate = p_191379_0_.func_70661_as();
        Random random = p_191379_0_.func_70681_au();
        boolean flag = p_191379_0_.func_213394_dL() ? (d0 = p_191379_0_.func_213384_dI().func_218140_a((double)MathHelper.func_76128_c((double)p_191379_0_.func_226277_ct_()), (double)MathHelper.func_76128_c((double)p_191379_0_.func_226278_cu_()), (double)MathHelper.func_76128_c((double)p_191379_0_.func_226281_cx_()), true) + 4.0) < (d1 = (double)(p_191379_0_.func_213391_dJ() + (float)p_191379_1_)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * p_191379_1_ + 1) - p_191379_1_;
            int i1 = random.nextInt(2 * p_191379_2_ + 1) - p_191379_2_;
            int j1 = random.nextInt(2 * p_191379_1_ + 1) - p_191379_1_;
            if (p_191379_3_ != null && !((double)l * p_191379_3_.field_72450_a + (double)j1 * p_191379_3_.field_72449_c >= 0.0)) continue;
            if (p_191379_0_.func_213394_dL() && p_191379_1_ > 1) {
                BlockPos blockpos = p_191379_0_.func_213384_dI();
                l = p_191379_0_.func_226277_ct_() > (double)blockpos.func_177958_n() ? (l -= random.nextInt(p_191379_1_ / 2)) : (l += random.nextInt(p_191379_1_ / 2));
                j1 = p_191379_0_.func_226281_cx_() > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(p_191379_1_ / 2)) : (j1 += random.nextInt(p_191379_1_ / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + p_191379_0_.func_226277_ct_(), (double)i1 + p_191379_0_.func_226278_cu_(), (double)j1 + p_191379_0_.func_226281_cx_());
            if (flag && !p_191379_0_.func_213389_a(blockpos1) || !pathnavigate.func_188555_b(blockpos1) || !p_191379_4_ && RatUtils.isWaterDestination(blockpos1 = RatUtils.moveAboveSolid(blockpos1, p_191379_0_), p_191379_0_) || !((f1 = p_191379_0_.func_180484_a(blockpos1)) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + p_191379_0_.func_226277_ct_(), (double)i + p_191379_0_.func_226278_cu_(), (double)j + p_191379_0_.func_226281_cx_());
        }
        return null;
    }

    private static BlockPos moveAboveSolid(BlockPos p_191378_0_, CreatureEntity p_191378_1_) {
        if (!p_191378_1_.field_70170_p.func_180495_p(p_191378_0_).func_185904_a().func_76220_a()) {
            return p_191378_0_;
        }
        BlockPos blockpos = p_191378_0_.func_177984_a();
        while (blockpos.func_177956_o() < p_191378_1_.field_70170_p.func_217301_I() && p_191378_1_.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76220_a()) {
            blockpos = blockpos.func_177984_a();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos p_191380_0_, CreatureEntity p_191380_1_) {
        return p_191380_1_.field_70170_p.func_180495_p(p_191380_0_).func_185904_a() == Material.field_151586_h;
    }

    public static boolean canSpawnInDimension(IWorld world) {
        if (RatConfig.blacklistedRatDimensions.length > 0) {
            for (int i = 0; i < RatConfig.blacklistedRatDimensions.length; ++i) {
                if (RatConfig.blacklistedRatDimensions[i] != world.func_201675_m().func_186058_p().func_186068_a()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCow(Entity entity) {
        String s = entity.func_200600_R().func_210760_d();
        if (s == null) {
            s = "generic";
        }
        return entity instanceof CowEntity || s.contains("cow");
    }

    public static void polinateAround(World world, BlockPos position) {
        int RADIUS = 10;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)position.func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            if (!RatUtils.canPlantBeBonemealed(world, pos, world.func_180495_p(pos))) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            for (BlockPos pos : allBlocks) {
                IGrowable igrowable;
                BlockState block = world.func_180495_p(pos);
                if (!(block.func_177230_c() instanceof IGrowable) || !(igrowable = (IGrowable)block.func_177230_c()).func_176473_a((IBlockReader)world, pos, block, world.field_72995_K) || world.field_73012_v.nextInt(3) != 0 || world.field_72995_K) continue;
                world.func_217379_c(2005, pos, 0);
                igrowable.func_225535_a_((ServerWorld)world, world.field_73012_v, pos, block);
            }
        }
    }

    private static boolean canPlantBeBonemealed(World world, BlockPos pos, BlockState BlockState2) {
        IGrowable igrowable;
        if (BlockState2.func_177230_c() instanceof IGrowable && !(BlockState2.func_177230_c() instanceof TallGrassBlock) && !(BlockState2.func_177230_c() instanceof GrassBlock) && (igrowable = (IGrowable)BlockState2.func_177230_c()).func_176473_a((IBlockReader)world, pos, BlockState2, world.field_72995_K) && !world.field_72995_K) {
            return igrowable.func_180670_a(world, world.field_73012_v, pos, BlockState2);
        }
        return false;
    }

    public static void accelerateTick(World world, BlockPos pos) {
        TileEntity tileEntity;
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!world.field_72995_K && world instanceof ServerWorld && block.func_149653_t(blockState) && world.func_201674_k().nextInt(40) == 0) {
            block.func_225542_b_(blockState, (ServerWorld)world, pos, world.func_201674_k());
        }
        if (block.hasTileEntity(blockState) && (tileEntity = world.func_175625_s(pos)) != null && !tileEntity.func_145837_r() && tileEntity instanceof ITickableTileEntity) {
            for (int i = 0; i < 4; ++i) {
                ((ITickableTileEntity)tileEntity).func_73660_a();
            }
        }
    }

    public static class TubeSorter
    implements Comparator<Direction> {
        private final EntityRat theEntity;

        public TubeSorter(EntityRat theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Direction p_compare_1_, Direction p_compare_2_) {
            double d1;
            BlockPos pos1 = new BlockPos((Entity)this.theEntity).func_177972_a(p_compare_1_);
            BlockPos pos2 = new BlockPos((Entity)this.theEntity).func_177972_a(p_compare_2_);
            double d0 = this.theEntity.tubeTarget.func_218140_a((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p(), true);
            return d0 < (d1 = this.theEntity.tubeTarget.func_218140_a((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p(), true)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

