/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatShot;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.ISummonsRats;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityRatKing
extends MonsterEntity
implements IAnimatedEntity,
IRatlantean,
ISummonsRats {
    public static final int RAT_COUNT = 15;
    public static final float RAT_ANGLE = 24.0f;
    private int animationTick;
    private Animation currentAnimation;
    private static final DataParameter<String> RAT_COLORS = EntityDataManager.func_187226_a(EntityRatKing.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> SUMMONED_RATS = EntityDataManager.func_187226_a(EntityRatKing.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Predicate<LivingEntity> NOT_RAT = new Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity.func_70089_S() && !(entity instanceof EntityRat) && !(entity instanceof EntityRatKing);
        }
    };

    public EntityRatKing(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, NOT_RAT));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RAT_COLORS, (Object)"000000000000000");
        this.field_70180_af.func_187214_a(SUMMONED_RATS, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(1.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        LivingEntity target = this.func_70638_az();
        if (!this.field_70170_p.field_72995_K && target != null & this.field_70173_aa % 15 == 0 && this.getRatsSummoned() < 10) {
            EntityRatShot cannonball = new EntityRatShot(RatsEntityRegistry.RAT_SHOT, this.field_70170_p, (LivingEntity)this);
            cannonball.setColorVariant(this.field_70146_Z.nextInt(4));
            float radius = 1.6f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = this.func_226277_ct_();
            double extraZ = this.func_226281_cx_();
            double extraY = 0.2 + this.func_226278_cu_();
            double d0 = target.func_226280_cw_() - (double)1.2f;
            double d1 = target.func_226277_ct_() - extraX;
            double d3 = target.func_226281_cx_() - extraZ;
            double d2 = d0 - extraY;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 1.0f;
            float velocity = Math.min(MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.06f, 1.4f);
            cannonball.func_70107_b(extraX, extraY, extraZ);
            cannonball.func_70186_c(d1, d2 + (double)f, d3, velocity, 0.0f);
            this.func_184185_a(SoundEvents.field_187737_v, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)cannonball);
            }
        }
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            for (int i = 0; i < 3 + this.field_70146_Z.nextInt(3); ++i) {
                this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public int func_70627_aG() {
        return 20;
    }

    protected void func_184581_c(DamageSource source) {
        SoundEvent soundevent = this.func_184601_bQ(source);
        if (soundevent != null) {
            for (int i = 0; i < 3 + this.field_70146_Z.nextInt(3); ++i) {
                this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RAT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RAT_DIE;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        for (int i = 0; i < 15; ++i) {
            int color = this.field_70146_Z.nextInt(4);
            this.setRatColors(i, color);
        }
        return spawnDataIn;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("RatColors", this.getRatColorsString());
        compound.func_74768_a("RatsSummoned", this.getRatsSummoned());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRatsSummoned(compound.func_74762_e("RatsSummoned"));
        this.setRatColorsString(compound.func_74779_i("RatColors"));
    }

    private void setRatColorsString(String str) {
        this.field_70180_af.func_187227_b(RAT_COLORS, (Object)str);
    }

    private String getRatColorsString() {
        return (String)this.field_70180_af.func_187225_a(RAT_COLORS);
    }

    public void setRatColors(int index, int color) {
        String ratColors = this.getRatColorsString();
        if (ratColors.length() < 14) {
            ratColors = "000000000000000";
        }
        String before = ratColors.substring(0, index);
        String after = ratColors.substring(index, 14);
        String newStr = before + color + after;
        this.setRatColorsString(newStr);
    }

    public int getRatColors(int index) {
        String ratColors = this.getRatColorsString();
        if (ratColors.length() < 14) {
            ratColors = "000000000000000";
        }
        char c = ratColors.charAt(index);
        return Integer.parseInt(String.valueOf(c));
    }

    @Override
    public boolean encirclesSummoner() {
        return true;
    }

    @Override
    public boolean readsorbRats() {
        return this.getRatsSummoned() > 5;
    }

    @Override
    public int getRatsSummoned() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMONED_RATS);
    }

    @Override
    public void setRatsSummoned(int count) {
        this.field_70180_af.func_187227_b(SUMMONED_RATS, (Object)count);
    }

    @Override
    public float getRadius() {
        return 3.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos((Entity)this);
        if (!this.field_70170_p.func_180495_p(pos).func_200132_m()) {
            return pos.func_177984_a();
        }
        return pos;
    }
}

