/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.type.RatsRenderType;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatColorUtil;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;

public class LayerRatPlague
extends LayerRenderer<EntityRat, SegmentedModel<EntityRat>> {
    private static final RenderType TEXTURE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_plague_overlay.png"));
    private static final RenderType TEXTURE_DYED_NOT = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_dyed_not.png"));
    private static final RenderType TEXTURE_DYED = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_dyed.png"));
    private static final RenderType TEXTURE_LUMBERJACK = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_lumberjack_upgrade.png"));
    private static final RenderType TEXTURE_TOGA = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/toga.png"));
    private static final RenderType TEXTURE_RATINATOR = RenderType.func_228646_f_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_ratinator_upgrade.png"));
    private static final ResourceLocation TEXTURE_PSYCHIC = new ResourceLocation("rats:textures/entity/ratlantis/psychic.png");
    private ResourceLocation TEXTURE_GHOST = new ResourceLocation("rats:textures/entity/ratlantis/ghost_pirat_overlay.png");
    private ResourceLocation TEXTURE_DYED_LOC = new ResourceLocation("rats:textures/entity/rat/rat_dyed.png");
    private static final ModelRat RAT_MODEL = new ModelRat(0.5f);
    private final IEntityRenderer<EntityRat, SegmentedModel<EntityRat>> ratRenderer;

    public LayerRatPlague(IEntityRenderer<EntityRat, SegmentedModel<EntityRat>> ratRendererIn) {
        super(ratRendererIn);
        this.ratRenderer = ratRendererIn;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityRat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IVertexBuilder ivertexbuilder;
        if (!(this.ratRenderer.func_217764_d() instanceof ModelRat)) {
            return;
        }
        if (rat.isDyed()) {
            float r;
            if (rat.getDyeColor() == 100) {
                ivertexbuilder = bufferIn.getBuffer(RatsRenderType.RAINBOW_GLINT);
                r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)rat, (float)0.0f), r, g, b, 1.0f);
                IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(TEXTURE_DYED_NOT);
                ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)rat, (float)0.0f), r, g, b, 1.0f);
            } else {
                ivertexbuilder = bufferIn.getBuffer(TEXTURE_DYED);
                float[] lvt_14_2_ = RatColorUtil.getDyeRgb(DyeColor.func_196056_a((int)rat.getDyeColor()));
                r = lvt_14_2_[0];
                float g = lvt_14_2_[1];
                float b = lvt_14_2_[2];
                ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)rat, (float)0.0f), r, g, b, 1.0f);
            }
        }
        if (rat.hasPlague()) {
            ivertexbuilder = bufferIn.getBuffer(TEXTURE);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)rat, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY) && rat.getHeldRF() > 0) {
            float f = (float)rat.field_70173_aa + partialTicks;
            IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)TEXTURE_PSYCHIC, (float)(f * 0.01f), (float)(f * 0.01f)));
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225597_a_((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
            IVertexBuilder ivertexbuilder3 = bufferIn.getBuffer(TEXTURE_RATINATOR);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder3, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            IVertexBuilder ivertexbuilder4 = bufferIn.getBuffer(TEXTURE_LUMBERJACK);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder4, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasToga()) {
            IVertexBuilder ivertexbuilder5 = bufferIn.getBuffer(TEXTURE_TOGA);
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder5, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            float f = (float)rat.field_70173_aa + partialTicks;
            IVertexBuilder ivertexbuilder6 = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.TEXTURE_GHOST, (float)(f * 0.01f), (float)(f * 0.01f)));
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225597_a_((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ((SegmentedModel)this.ratRenderer.func_217764_d()).func_225598_a_(matrixStackIn, ivertexbuilder6, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    public boolean shouldCombineTextures() {
        return false;
    }
}

