/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.type.RatsRenderType;
import com.github.alexthe666.rats.server.entity.EntityGhostPirat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.ItemChefToque;
import com.github.alexthe666.rats.server.items.ItemPiperHat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BannerItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class LayerRatHelmet<T extends EntityRat>
extends LayerRenderer<T, ModelRat<T>> {
    private float alpha = 1.0f;
    private float colorR = 1.0f;
    private float colorG = 1.0f;
    private float colorB = 1.0f;
    private final IEntityRenderer<T, ModelRat<T>> renderer;
    private final BipedModel defaultBipedModel = new BipedModel(1.0f);
    private static final BipedModel backup = new BipedModel(1.0f);
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public LayerRatHelmet(IEntityRenderer<T, ModelRat<T>> rendererIn) {
        super(rendererIn);
        this.renderer = rendererIn;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack;
        IVertexBuilder vertexBuilder;
        if (!(this.renderer.func_217764_d() instanceof ModelRat)) {
            return;
        }
        matrixStackIn.func_227860_a_();
        if (((EntityRat)rat).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GOD)) {
            vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)this.renderer.func_110775_a(rat)), (boolean)false, (boolean)true);
            ((ModelRat)this.renderer.func_217764_d()).func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (((EntityRat)rat).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER)) {
            vertexBuilder = bufferIn.getBuffer(RatsRenderType.GREEN_ENTITY_GLINT);
            ((ModelRat)this.renderer.func_217764_d()).func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if ((itemstack = ((EntityRat)rat).func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)itemstack.func_77973_b();
            if (armoritem.func_185083_B_() == EquipmentSlotType.HEAD) {
                BipedModel<?> a = this.defaultBipedModel;
                a = this.getArmorModelHook((LivingEntity)rat, itemstack, EquipmentSlotType.HEAD, (BipedModel)a);
                this.setModelSlotVisible(a, EquipmentSlotType.HEAD);
                boolean flag = false;
                ((ModelRat)this.renderer.func_217764_d()).body1.func_228307_a_(matrixStackIn);
                ((ModelRat)this.renderer.func_217764_d()).body2.func_228307_a_(matrixStackIn);
                ((ModelRat)this.renderer.func_217764_d()).neck.func_228307_a_(matrixStackIn);
                ((ModelRat)this.renderer.func_217764_d()).head.func_228307_a_(matrixStackIn);
                matrixStackIn.func_227861_a_(0.0, -0.375, (double)-0.045f);
                matrixStackIn.func_227862_a_(0.55f, 0.55f, 0.55f);
                if (itemstack.func_77973_b() instanceof ItemChefToque) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -25.0f, true));
                    matrixStackIn.func_227861_a_(0.0, (double)0.1f, (double)0.3f);
                }
                if (itemstack.func_77973_b() instanceof ItemPiperHat) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -10.0f, true));
                    matrixStackIn.func_227861_a_(0.0, (double)0.1f, (double)0.1f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.PIRAT_HAT) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227861_a_(0.0, -0.125, 0.0);
                    matrixStackIn.func_227862_a_(1.425f, 1.425f, 1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.GHOST_PIRAT_HAT) {
                    float piratScale = rat instanceof EntityGhostPirat ? 1.1f : 1.425f;
                    float piratTranslate = rat instanceof EntityGhostPirat ? 0.05f : -0.125f;
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.3f);
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227861_a_(0.0, (double)piratTranslate, 0.0);
                    matrixStackIn.func_227862_a_(piratScale, piratScale, piratScale);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.ARCHEOLOGIST_HAT) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227862_a_(1.425f, 1.425f, 1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.FARMER_HAT || itemstack.func_77973_b() == RatsItemRegistry.FISHERMAN_HAT) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227862_a_(1.425f, 1.425f, 1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.PLAGUE_DOCTOR_MASK || itemstack.func_77973_b() == RatsItemRegistry.BLACK_DEATH_MASK) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -15.0f, true));
                    matrixStackIn.func_227861_a_(0.0, 0.0, 0.0);
                    matrixStackIn.func_227862_a_(1.5f, 1.2f, 1.5f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.RAT_FEZ) {
                    matrixStackIn.func_227861_a_((double)-0.15f, (double)-0.05f, (double)-0.1f);
                    matrixStackIn.func_227862_a_(1.425f, 1.425f, 1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.TOP_HAT) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227862_a_(1.425f, 1.425f, 1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.SANTA_HAT) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227861_a_(0.0, 0.0, (double)0.1f);
                    matrixStackIn.func_227862_a_(1.25f, 1.25f, 1.25f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_1 || itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_2 || itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_3 || itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_4) {
                    matrixStackIn.func_227861_a_(0.0, (double)0.075f, (double)-0.05f);
                    matrixStackIn.func_227862_a_(1.25f, 1.25f, 1.25f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.MILITARY_HAT) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227862_a_(1.425f, 1.425f, 1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.RAT_KING_CROWN) {
                    matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -5.0f, true));
                    matrixStackIn.func_227861_a_(0.0, (double)0.075f, 0.0);
                    matrixStackIn.func_227862_a_(1.25f, 1.25f, 1.25f);
                }
                boolean flag1 = itemstack.func_77962_s();
                if (armoritem instanceof IDyeableArmorItem) {
                    int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderArmor(matrixStackIn, bufferIn, packedLightIn, flag1, a, f, f1, f2, LayerRatHelmet.getArmorResource(rat, itemstack, EquipmentSlotType.HEAD, null));
                    this.renderArmor(matrixStackIn, bufferIn, packedLightIn, flag1, a, 1.0f, 1.0f, 1.0f, LayerRatHelmet.getArmorResource(rat, itemstack, EquipmentSlotType.HEAD, "overlay"));
                } else {
                    this.renderArmor(matrixStackIn, bufferIn, packedLightIn, flag1, a, 1.0f, 1.0f, 1.0f, LayerRatHelmet.getArmorResource(rat, itemstack, EquipmentSlotType.HEAD, null));
                }
            }
        } else if (itemstack.func_77973_b() instanceof BannerItem) {
            ((ModelRat)this.renderer.func_217764_d()).body1.func_228307_a_(matrixStackIn);
            ((ModelRat)this.renderer.func_217764_d()).body2.func_228307_a_(matrixStackIn);
            matrixStackIn.func_227861_a_(0.0, -0.5, (double)-0.2f);
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
            float sitProgress = ((EntityRat)rat).sitProgress / 20.0f;
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, sitProgress * -40.0f, true));
            matrixStackIn.func_227861_a_(0.0, 0.0, (double)(-sitProgress * 0.04f));
            matrixStackIn.func_227862_a_(1.7f, 1.7f, 1.7f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        } else {
            ((ModelRat)this.renderer.func_217764_d()).body1.func_228307_a_(matrixStackIn);
            ((ModelRat)this.renderer.func_217764_d()).body2.func_228307_a_(matrixStackIn);
            ((ModelRat)this.renderer.func_217764_d()).neck.func_228307_a_(matrixStackIn);
            ((ModelRat)this.renderer.func_217764_d()).head.func_228307_a_(matrixStackIn);
            matrixStackIn.func_227861_a_(0.0, (double)0.025f, (double)-0.2f);
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
            matrixStackIn.func_227862_a_(0.8f, 0.8f, 0.8f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        }
        matrixStackIn.func_227865_b_();
    }

    private void renderArmor(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean glintIn, BipedModel modelIn, float red, float green, float blue, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    protected void setModelSlotVisible(BipedModel p_188359_1_, EquipmentSlotType slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.field_78116_c.field_78806_j = true;
                p_188359_1_.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178723_h.field_78806_j = true;
                p_188359_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
            }
        }
    }

    protected void setModelVisible(BipedModel model) {
        model.func_178719_a(false);
    }

    protected BipedModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slot, BipedModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlotType)slot, (BipedModel)model);
    }
}

