/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.datagen.recipe.PneumaticCraftRecipeBuilder;
import me.desht.pneumaticcraft.datagen.recipe.SerializerHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class HeatFrameCoolingRecipeBuilder
extends PneumaticCraftRecipeBuilder<HeatFrameCoolingRecipeBuilder> {
    private final Ingredient input;
    private final int temperature;
    private final ItemStack output;
    private final float bonusMultiplier;
    private final float bonusLimit;

    protected HeatFrameCoolingRecipeBuilder(Ingredient input, int temperature, ItemStack output) {
        this(input, temperature, output, 0.0f, 0.0f);
    }

    public HeatFrameCoolingRecipeBuilder(Ingredient input, int temperature, ItemStack output, float bonusMultiplier, float bonusLimit) {
        super(PneumaticCraftUtils.RL("heat_frame_cooling"));
        this.input = input;
        this.temperature = temperature;
        this.output = output;
        this.bonusMultiplier = bonusMultiplier;
        this.bonusLimit = bonusLimit;
    }

    @Override
    protected PneumaticCraftRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new HeatFrameCoolingRecipeResult(id);
    }

    public class HeatFrameCoolingRecipeResult
    extends PneumaticCraftRecipeBuilder.RecipeResult {
        HeatFrameCoolingRecipeResult(ResourceLocation id) {
            super(HeatFrameCoolingRecipeBuilder.this, id);
        }

        public void func_218610_a(JsonObject json) {
            json.add("input", HeatFrameCoolingRecipeBuilder.this.input.func_200304_c());
            json.addProperty("max_temp", (Number)HeatFrameCoolingRecipeBuilder.this.temperature);
            json.add("result", SerializerHelper.serializeOneItemStack(HeatFrameCoolingRecipeBuilder.this.output));
            if (HeatFrameCoolingRecipeBuilder.this.bonusMultiplier > 0.0f || HeatFrameCoolingRecipeBuilder.this.bonusLimit > 0.0f) {
                JsonObject bonus = new JsonObject();
                bonus.addProperty("multiplier", (Number)Float.valueOf(HeatFrameCoolingRecipeBuilder.this.bonusMultiplier));
                bonus.addProperty("limit", (Number)Float.valueOf(HeatFrameCoolingRecipeBuilder.this.bonusLimit));
                json.add("bonus_output", (JsonElement)bonus);
            }
        }
    }
}

