/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class JEIPlasticSolidifyingCategory
implements IRecipeCategory<PlasticSolidifyingRecipe> {
    private final String localizedName = I18n.func_135052_a((String)"gui.jei.title.plasticSolidifying", (Object[])new Object[0]);
    private final IDrawable background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_MISC_RECIPES, 0, 0, 82, 18);
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.PLASTIC.get()));

    JEIPlasticSolidifyingCategory() {
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.PLASTIC_SOLIDIFYING;
    }

    public Class<PlasticSolidifyingRecipe> getRecipeClass() {
        return PlasticSolidifyingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PlasticSolidifyingRecipe recipe, IIngredients ingredients) {
        if (recipe.input instanceof FluidIngredient) {
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(((FluidIngredient)recipe.input).getFluidStacks()));
        } else {
            ingredients.setInputIngredients(Collections.singletonList(recipe.input));
        }
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PlasticSolidifyingRecipe recipe, IIngredients ingredients) {
        if (recipe.input instanceof FluidIngredient) {
            recipeLayout.getFluidStacks().init(0, true, 1, 1);
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        } else {
            recipeLayout.getItemStacks().init(0, true, 0, 0);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        recipeLayout.getItemStacks().init(1, false, 64, 0);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public List<String> getTooltipStrings(PlasticSolidifyingRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> res = new ArrayList<String>();
        if (mouseX >= 23.0 && mouseX <= 60.0) {
            res.add(I18n.func_135052_a((String)"gui.jei.tooltip.plasticSolidifying", (Object[])new Object[0]));
        }
        return res;
    }

    public static Collection<PlasticSolidifyingRecipe> getAllRecipes() {
        return ImmutableList.of((Object)new PlasticSolidifyingRecipe(FluidIngredient.of(1000, (Fluid)ModFluids.PLASTIC.get()), new ItemStack((IItemProvider)ModItems.PLASTIC.get())), (Object)new PlasticSolidifyingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.PLASTIC_BUCKET.get())}), new ItemStack((IItemProvider)ModItems.PLASTIC.get())));
    }

    static class PlasticSolidifyingRecipe {
        final Ingredient input;
        final ItemStack output;

        PlasticSolidifyingRecipe(Ingredient input, ItemStack output) {
            this.input = input;
            this.output = output;
        }
    }
}

