/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.block.BlockThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class ThermoPlantRecipeImpl
extends ThermoPlantRecipe {
    private final FluidIngredient inputFluid;
    private final FluidStack outputFluid;
    private final Ingredient inputItem;
    private final float requiredPressure;
    private final boolean exothermic;
    private final TemperatureRange operatingTemperature;
    private final ItemStack outputItem;

    public ThermoPlantRecipeImpl(ResourceLocation id, @Nonnull FluidIngredient inputFluid, @Nullable Ingredient inputItem, FluidStack outputFluid, ItemStack outputItem, TemperatureRange operatingTemperature, float requiredPressure, boolean exothermic) {
        super(id);
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.exothermic = exothermic;
        Validate.isTrue((!inputFluid.func_203189_d() || !inputItem.func_203189_d() ? 1 : 0) != 0, (String)"At least on of input fluid or input item must be non-empty!", (Object[])new Object[0]);
    }

    @Override
    public boolean matches(FluidStack fluidStack, @Nonnull ItemStack stack) {
        return !(this.inputFluid != null && !this.inputFluid.testFluid(fluidStack) || this.inputItem != null && !this.inputItem.test(stack));
    }

    @Override
    public TemperatureRange getOperatingTemperature() {
        return this.operatingTemperature;
    }

    @Override
    public float getRequiredPressure() {
        return this.requiredPressure;
    }

    @Override
    public FluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    @Override
    @Nonnull
    public Ingredient getInputItem() {
        return this.inputItem;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public boolean isExothermic() {
        return this.exothermic;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.operatingTemperature.write(buffer);
        buffer.writeFloat(this.requiredPressure);
        this.inputItem.func_199564_a(buffer);
        this.inputFluid.func_199564_a(buffer);
        this.outputFluid.writeToPacket(buffer);
        buffer.func_150788_a(this.outputItem);
        buffer.writeBoolean(this.exothermic);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.THERMO_PLANT.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.THERMO_PLANT;
    }

    public String func_193358_e() {
        return ((BlockThermopneumaticProcessingPlant)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).getRegistryName().func_110623_a();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get());
    }

    public static class Serializer<T extends ThermoPlantRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            ItemStack itemOutput;
            FluidIngredient fluidInput;
            Ingredient itemInput = json.has("item_input") ? Ingredient.func_199802_a((JsonElement)json.get("item_input")) : Ingredient.field_193370_a;
            FluidIngredient fluidIngredient = fluidInput = json.has("fluid_input") ? FluidIngredient.func_199802_a((JsonElement)json.get("fluid_input")) : FluidIngredient.EMPTY;
            if (itemInput.func_203189_d() && fluidInput.func_203189_d()) {
                throw new JsonSyntaxException("Must have at least one of item_input and/or fluid_input!");
            }
            FluidStack fluidOutput = json.has("fluid_output") ? ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject("fluid_output")) : FluidStack.EMPTY;
            ItemStack itemStack = itemOutput = json.has("item_output") ? ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"item_output")) : ItemStack.field_190927_a;
            if (fluidOutput.isEmpty() && itemOutput.func_190926_b()) {
                throw new JsonSyntaxException("Must have at least one of item_output and/or fluid_output!");
            }
            TemperatureRange range = json.has("temperature") ? TemperatureRange.fromJson(json.getAsJsonObject("temperature")) : TemperatureRange.any();
            float pressure = JSONUtils.func_151221_a((JsonObject)json, (String)"pressure", (float)0.0f);
            boolean exothermic = JSONUtils.func_151209_a((JsonObject)json, (String)"exothermic", (boolean)false);
            return this.factory.create(recipeId, fluidInput, itemInput, fluidOutput, itemOutput, range, pressure, exothermic);
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            TemperatureRange range = TemperatureRange.read(buffer);
            float pressure = buffer.readFloat();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidIngredient fluidIn = (FluidIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack fluidOut = FluidStack.readFromPacket((PacketBuffer)buffer);
            ItemStack itemOutput = buffer.func_150791_c();
            boolean exothermic = buffer.readBoolean();
            return this.factory.create(recipeId, fluidIn, input, fluidOut, itemOutput, range, pressure, exothermic);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends ThermoPlantRecipe> {
            public T create(ResourceLocation var1, @Nonnull FluidIngredient var2, @Nullable Ingredient var3, FluidStack var4, ItemStack var5, TemperatureRange var6, float var7, boolean var8);
        }
    }
}

