/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ProgWidgetEntityExport
extends ProgWidgetAreaItemBase {
    public ProgWidgetEntityExport() {
        super(ModProgWidgets.ENTITY_EXPORT);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ENTITY_EX;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA, ModProgWidgets.TEXT);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.ORANGE;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockInteraction<ProgWidgetEntityExport>(drone, (ProgWidgetEntityExport)widget){

            @Override
            public boolean func_75250_a() {
                if (this.drone.getCarryingEntities().isEmpty()) {
                    return false;
                }
                for (Entity e : this.drone.getCarryingEntities()) {
                    if (((ProgWidgetEntityExport)this.progWidget).isEntityValid(e)) continue;
                    return false;
                }
                return super.func_75250_a();
            }

            @Override
            protected boolean isValidPosition(BlockPos pos) {
                return true;
            }

            @Override
            protected boolean moveIntoBlock() {
                return true;
            }

            @Override
            protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
                this.drone.setCarryingEntity(null);
                return false;
            }
        };
    }
}

