/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerProgrammer
extends ContainerPneumaticBase<TileEntityProgrammer> {
    private final boolean hiRes;

    public ContainerProgrammer(int i, PlayerInventory playerInventory, BlockPos pos) {
        super((ContainerType)ModContainers.PROGRAMMER.get(), i, playerInventory, pos);
        this.hiRes = playerInventory.field_70458_d.field_70170_p.field_72995_K && ClientUtils.isScreenHiRes();
        int xBase = this.hiRes ? 270 : 95;
        int yBase = this.hiRes ? 430 : 174;
        this.func_75146_a((Slot)new SlotItemHandler(((TileEntityProgrammer)this.te).getPrimaryInventory(), 0, this.hiRes ? 676 : 326, 15){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return ContainerProgrammer.isProgrammableItem(stack);
            }
        });
        this.addPlayerSlots(playerInventory, xBase, yBase);
    }

    public ContainerProgrammer(int i, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(i, playerInventory, ContainerProgrammer.getTilePos(buffer));
    }

    public boolean isHiRes() {
        return this.hiRes;
    }

    private static boolean isProgrammableItem(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IProgrammable && ((IProgrammable)stack.func_77973_b()).canProgram(stack);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (((TileEntityProgrammer)this.te).func_145831_w().func_82737_E() % 20L == 0L) {
            for (Direction d : Direction.field_199792_n) {
                TileEntity neighbor = ((TileEntityProgrammer)this.te).getTileCache()[d.func_176745_a()].getTileEntity();
                if (neighbor == null || !neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d()).isPresent()) continue;
                this.sendToContainerListeners(new PacketSendNBTPacket(neighbor));
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(PlayerEntity par1EntityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot srcSlot = (Slot)this.field_75151_b.get(slotIndex);
        if (srcSlot != null && srcSlot.func_75216_d()) {
            ItemStack stackInSlot = srcSlot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slotIndex == 0) {
                if (!this.func_75135_a(stackInSlot, 1, 36, false)) {
                    return ItemStack.field_190927_a;
                }
                srcSlot.func_75220_a(stackInSlot, stack);
            } else if (ContainerProgrammer.isProgrammableItem(stack)) {
                if (!this.func_75135_a(stackInSlot, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                srcSlot.func_75220_a(stackInSlot, stack);
            }
            if (stackInSlot.func_190926_b()) {
                srcSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                srcSlot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            srcSlot.func_190901_a(par1EntityPlayer, stackInSlot);
        }
        return stack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (playerIn.field_70170_p.field_72995_K) {
            GuiProgrammer.onCloseFromContainer();
        }
    }
}

