/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Collection;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class HeatUtil {
    private static final int COMPARATOR_MIN = 73;
    private static final int COMPARATOR_MAX = 473;

    public static TintColor getColourForTemperature(int temperature) {
        float s;
        int h;
        if (temperature < 273) {
            h = 180 + (300 - temperature) / 5;
            s = 0.25f + (float)(273 - temperature) / 273.0f * 0.75f;
        } else if (temperature < 323) {
            h = 360;
            s = 0.0f;
        } else if (temperature < 873) {
            h = (int)((float)temperature / 873.0f * 30.0f);
            s = (float)temperature / 873.0f;
        } else {
            h = 30 + (int)((float)temperature / 2273.0f * 10.0f);
            s = 1.0f;
        }
        return TintColor.getHSBColor((float)h / 360.0f, s, 1.0f);
    }

    public static int getComparatorOutput(int temperature) {
        if ((temperature -= 200) < 73) {
            return 0;
        }
        if (temperature > 473) {
            return 15;
        }
        return (temperature - 73) * 16 / 400;
    }

    public static int getEfficiency(int temperature) {
        return MathHelper.func_76125_a((int)((625 - temperature) / 3), (int)0, (int)100);
    }

    public static ITextComponent formatHeatString(int tempK) {
        return HeatUtil.formatHeatString(tempK - 273 + "\u00b0C");
    }

    public static ITextComponent formatHeatString(Direction face, int tempK) {
        return HeatUtil.formatHeatString(face, tempK - 273 + "\u00b0C");
    }

    public static ITextComponent formatHeatString(String temp) {
        return PneumaticCraftUtils.xlate("waila.temperature", new Object[0]).func_150258_a(TextFormatting.WHITE.toString() + temp).func_211709_a(new TextFormatting[]{TextFormatting.GRAY});
    }

    public static ITextComponent formatHeatString(Direction face, String temp) {
        return PneumaticCraftUtils.xlate("waila.temperature." + face.toString().toLowerCase(), new Object[0]).func_150258_a(TextFormatting.WHITE.toString() + temp).func_211709_a(new TextFormatting[]{TextFormatting.GRAY});
    }

    public static int countExposedFaces(Collection<? extends TileEntity> teList) {
        int exposed = 0;
        for (TileEntity tileEntity : teList) {
            for (Direction face : Direction.values()) {
                if (!tileEntity.func_145831_w().func_175623_d(tileEntity.func_174877_v().func_177972_a(face))) continue;
                ++exposed;
            }
        }
        return exposed;
    }
}

