/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.aux;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.aux.AuxConfigJson;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class MicromissileDefaults
extends AuxConfigJson {
    public static final MicromissileDefaults INSTANCE = new MicromissileDefaults();
    private static final Map<UUID, Entry> defaults = new HashMap<UUID, Entry>();

    private MicromissileDefaults() {
        super(false);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        JsonObject sub = new JsonObject();
        for (Map.Entry<UUID, Entry> entry : defaults.entrySet()) {
            sub.add(entry.getKey().toString(), (JsonElement)entry.getValue().toJson());
        }
        json.addProperty("Description", "Stores default Micromissile settings on a per-player basis");
        json.add("defaults", (JsonElement)sub);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        defaults.clear();
        JsonObject sub = json.getAsJsonObject("defaults");
        for (Map.Entry entry : sub.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                defaults.put(UUID.fromString((String)entry.getKey()), Entry.fromJson(((JsonElement)entry.getValue()).getAsJsonObject()));
                continue;
            }
            Log.warning("Invalid JSON? entry '" + (String)entry.getKey() + "' in " + this.getConfigFilename(), new Object[0]);
        }
    }

    @Override
    public String getConfigFilename() {
        return "MicromissileDefaults";
    }

    public void setDefaults(PlayerEntity player, Entry record) {
        record.playerName = player.func_200200_C_().func_150254_d();
        defaults.put(player.func_110124_au(), record);
    }

    public Entry getDefaults(PlayerEntity player) {
        return defaults.get(player.func_110124_au());
    }

    public static class Entry {
        public final float topSpeed;
        public final float turnSpeed;
        public final float damage;
        public final PointXY p;
        public final String entityFilter;
        public final ItemMicromissiles.FireMode fireMode;
        String playerName = "";

        public Entry(float topSpeed, float turnSpeed, float damage, PointXY p, String entityFilter, ItemMicromissiles.FireMode fireMode) {
            this.topSpeed = topSpeed;
            this.turnSpeed = turnSpeed;
            this.damage = damage;
            this.p = p;
            this.entityFilter = entityFilter;
            this.fireMode = fireMode;
        }

        static Entry fromJson(JsonObject value) {
            Entry entry = new Entry(value.get("topSpeed").getAsFloat(), value.get("turnSpeed").getAsFloat(), value.get("damage").getAsFloat(), new PointXY(value.get("px").getAsInt(), value.get("py").getAsInt()), value.get("entityFilter").getAsString(), ItemMicromissiles.FireMode.fromString(value.get("fireMode").getAsString()));
            entry.playerName = value.get("playerName").getAsString();
            return entry;
        }

        JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("topSpeed", (Number)Float.valueOf(this.topSpeed));
            obj.addProperty("turnSpeed", (Number)Float.valueOf(this.turnSpeed));
            obj.addProperty("damage", (Number)Float.valueOf(this.damage));
            obj.addProperty("px", (Number)this.p.x);
            obj.addProperty("py", (Number)this.p.y);
            obj.addProperty("entityFilter", this.entityFilter);
            obj.addProperty("playerName", this.playerName);
            obj.addProperty("fireMode", this.fireMode.toString());
            return obj;
        }

        public CompoundNBT toNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74776_a("topSpeed", this.topSpeed);
            tag.func_74776_a("turnSpeed", this.turnSpeed);
            tag.func_74776_a("damage", this.damage);
            tag.func_74778_a("filter", this.entityFilter);
            tag.func_74768_a("px", this.p.x);
            tag.func_74768_a("py", this.p.y);
            tag.func_74778_a("fireMode", this.fireMode.toString());
            return tag;
        }
    }
}

