/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.aux;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import me.desht.pneumaticcraft.common.config.aux.AuxConfigJson;

public class ArmorFeatureStatus
extends AuxConfigJson {
    private final Set<String> activeUpgrades = Sets.newHashSet();
    public static final ArmorFeatureStatus INSTANCE = new ArmorFeatureStatus();

    private ArmorFeatureStatus() {
        super(true);
    }

    @Override
    public String getConfigFilename() {
        return "ArmorFeatureStatus";
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("description", "Tracks the active upgrades for the Pneumatic Armor (clientside)");
        JsonArray array = new JsonArray();
        if (this.activeUpgrades.isEmpty()) {
            this.activeUpgrades.add("coreComponents");
        }
        for (String s : this.activeUpgrades) {
            array.add(s);
        }
        json.add("active", (JsonElement)array);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonArray array = json.get("active").getAsJsonArray();
        this.activeUpgrades.clear();
        for (JsonElement element : array) {
            this.activeUpgrades.add(element.getAsString());
        }
    }

    public void setUpgradeEnabled(String upgradeID, boolean enabled) {
        if (enabled) {
            this.activeUpgrades.add(upgradeID);
        } else {
            this.activeUpgrades.remove(upgradeID);
        }
    }

    public boolean isUpgradeEnabled(String upgradeID) {
        return this.activeUpgrades.contains(upgradeID);
    }
}

