/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockSecurityStation
extends BlockPneumaticCraft {
    private static final VoxelShape BODY = Block.func_208617_a((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
    private static final VoxelShape LEG1 = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)3.0);
    private static final VoxelShape LEG2 = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape LEG3 = Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)15.0);
    private static final VoxelShape LEG4 = Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)BODY, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, LEG3, LEG4});

    public BlockSecurityStation() {
        super(ModBlocks.defaultProps());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntitySecurityStation.class;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySecurityStation && entityLiving != null) {
            ((TileEntitySecurityStation)te).sharedUsers.add(((PlayerEntity)entityLiving).func_146103_bH());
        }
        super.func_180633_a(world, pos, state, entityLiving, iStack);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TileEntitySecurityStation te;
        if (player.func_226271_bk_()) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K && (te = (TileEntitySecurityStation)world.func_175625_s(pos)) != null) {
            if (te.isPlayerOnWhiteList(player)) {
                return super.func_225533_a_(state, world, pos, player, hand, brtr);
            }
            if (!te.hasValidNetwork()) {
                player.func_146105_b(PneumaticCraftUtils.xlate("message.securityStation.outOfOrder", new Object[0]), false);
            } else if (te.hasPlayerHacked(player)) {
                player.func_146105_b(PneumaticCraftUtils.xlate("message.securityStation.alreadyHacked", new Object[0]), false);
            } else if (this.getPlayerHackLevel(player) < te.getSecurityLevel()) {
                player.func_146105_b(PneumaticCraftUtils.xlate("message.securityStation.cantHack", te.getSecurityLevel()), false);
            } else {
                player.func_146105_b(new StringTextComponent("Sorry, but Security Station hacking is not yet implemented in this release of PneumaticCraft").func_211708_a(TextFormatting.GOLD), false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private int getPlayerHackLevel(PlayerEntity player) {
        ItemStack armorStack = player.func_184582_a(EquipmentSlotType.HEAD);
        return armorStack.func_77973_b() == ModItems.PNEUMATIC_HELMET.get() ? UpgradableItemUtils.getUpgrades(armorStack, EnumUpgrade.SECURITY) : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof TileEntitySecurityStation) {
            return ((TileEntitySecurityStation)te).shouldEmitRedstone() ? 15 : 0;
        }
        return 0;
    }
}

