/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.util.math.MathHelper;

public class RenderLaser {
    private static final float LASER_SIZE = 0.4f;

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, EntityDroneBase drone, double x1, double y1, double z1, double x2, double y2, double z2) {
        float laserLength = (float)PneumaticCraftUtils.distBetween(x1, y1, z1, x2, y2, z2);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x1, y1, z1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double rotYawRad = Math.atan2(dx, dz);
        double rotPitchRad = 1.5707963267948966 - Math.atan2(dy, f3);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)rotYawRad));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)rotPitchRad));
        matrixStack.func_227862_a_(0.4f, 0.4f, 0.4f);
        matrixStack.func_227861_a_(0.0, 0.6, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)drone.field_70173_aa + partialTicks));
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.0f, laserLength / 0.4f, 1.0f);
        int[] cols = RenderUtils.decomposeColor(drone.getLaserColor());
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER));
        this.renderQuad(posMat, builder, cols);
        builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_OVERLAY));
        this.renderQuad(posMat, builder, cols);
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        posMat = matrixStack.func_227866_c_().func_227870_a_();
        builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_START));
        this.renderQuad(posMat, builder, cols);
        builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_START_OVERLAY));
        this.renderQuad(posMat, builder, cols);
        matrixStack.func_227865_b_();
    }

    private void renderQuad(Matrix4f posMat, IVertexBuilder builder, int[] cols) {
        builder.func_227888_a_(posMat, -0.5f, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(0.0f, 0.0f).func_227886_a_(983280).func_181675_d();
        builder.func_227888_a_(posMat, -0.5f, 1.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(0.0f, 1.0f).func_227886_a_(983280).func_181675_d();
        builder.func_227888_a_(posMat, 0.5f, 1.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(1.0f, 1.0f).func_227886_a_(983280).func_181675_d();
        builder.func_227888_a_(posMat, 0.5f, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(1.0f, 0.0f).func_227886_a_(983280).func_181675_d();
    }
}

