/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class WidgetFluidStack
extends WidgetFluidFilter {
    public WidgetFluidStack(int x, int y, FluidStack stack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, stack, pressable);
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WidgetFluidFilter setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTick) {
        int fluidAmount;
        super.renderButton(mouseX, mouseY, partialTick);
        if (!this.fluidStack.isEmpty() && (fluidAmount = this.fluidStack.getAmount() / 1000) > 1) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            RenderSystem.translated((double)0.0, (double)0.0, (double)400.0);
            String s = fluidAmount + "B";
            fr.func_175063_a(s, (float)(this.x - fr.func_78256_a(s) + 17), (float)(this.y + 9), -1);
            RenderSystem.translated((double)0.0, (double)0.0, (double)-400.0);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clicked(mouseX, mouseY)) {
            if (!this.fluidStack.isEmpty()) {
                boolean shift = Screen.hasShiftDown();
                switch (button) {
                    case 0: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() / 2 : Math.max(0, this.fluidStack.getAmount() - 1000));
                        if (this.fluidStack.getAmount() >= 1000) break;
                        this.fluidStack.setAmount(0);
                        break;
                    }
                    case 1: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() * 2 : this.fluidStack.getAmount() + 1000);
                        break;
                    }
                    case 2: {
                        this.fluidStack.setAmount(0);
                    }
                }
            }
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shiftPressed) {
        super.addTooltip(mouseX, mouseY, curTip, shiftPressed);
        if (!this.fluidStack.isEmpty()) {
            curTip.add(TextFormatting.GRAY + "" + this.fluidStack.getAmount() + "mB");
        }
    }
}

