/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiMoveStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsUpgradeHandler;
import me.desht.pneumaticcraft.common.config.aux.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;

public class GuiJetBootsOptions
extends IOptionPage.SimpleToggleableOptions<JetBootsUpgradeHandler> {
    private WidgetKeybindCheckBox checkBox;

    public GuiJetBootsOptions(IGuiScreen screen, JetBootsUpgradeHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        super.populateGui(gui);
        this.checkBox = new WidgetKeybindCheckBox(5, 45, -1, "jetboots.module.builderMode", b -> this.setBuilderMode(b.checked));
        gui.addWidget(this.checkBox);
        gui.addWidget(new WidgetButtonExtended(30, 128, 150, 20, "Move Stat Screen...", b -> {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiMoveStat((IUpgradeRenderHandler)this.getUpgradeHandler(), ArmorHUDLayout.LayoutTypes.JET_BOOTS));
        }));
    }

    private void setBuilderMode(boolean enabled) {
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        if (commonArmorHandler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= 3) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("JetBootsBuilderMode", enabled);
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlotType.FEET, tag));
            CommonArmorHandler.getHandlerForPlayer().onDataFieldUpdated(EquipmentSlotType.FEET, "JetBootsBuilderMode", tag.func_74781_a("JetBootsBuilderMode"));
            HUDHandler.instance().addFeatureToggleMessage((IUpgradeRenderHandler)this.getUpgradeHandler(), "jetboots.module.builderMode", enabled);
        }
    }

    @Override
    public void tick() {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
        this.checkBox.active = handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= 3;
    }
}

