/*
 * Decompiled with CFR 0.152.
 */
package atm.bloodworkxgaming.serverstarter;

import atm.bloodworkxgaming.serverstarter.ServerStarter;
import atm.bloodworkxgaming.serverstarter.logger.PrimitiveLogger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Latm/bloodworkxgaming/serverstarter/InternetManager;", "", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "urls", "", "", "checkConnection", "", "downloadToFile", "", "url", "dest", "Ljava/io/File;", "serverstarter"})
public final class InternetManager {
    @NotNull
    private static final OkHttpClient httpClient;
    private static final List<String> urls;
    public static final InternetManager INSTANCE;

    @NotNull
    public final OkHttpClient getHttpClient() {
        return httpClient;
    }

    public final boolean checkConnection() {
        int reached = 0;
        for (String url : urls) {
            try {
                PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Pinging " + url + '.', false, 2, null);
                boolean r = InetAddress.getByName(url).isReachable(1000);
                PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Reached " + url + ": " + r, false, 2, null);
                if (!r) continue;
                ++reached;
            }
            catch (IOException e) {
                ServerStarter.Companion.getLOGGER().error("Error while pinging", e);
            }
        }
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Reached " + reached + " out of " + urls.size() + " IPs.", false, 2, null);
        if (reached != urls.size()) {
            PrimitiveLogger.error$default(ServerStarter.Companion.getLOGGER(), "Not every host could be reached. There could be a problem with your internet connection!!!!", null, 2, null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadToFile(@NotNull String url, @NotNull File dest) throws IOException {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(dest, "dest");
        Request req = new Request.Builder().url(url).get().build();
        Response res = httpClient.newCall(req).execute();
        Closeable closeable = res;
        BufferedSource source = closeable != null && (closeable = ((Response)closeable).body()) != null ? ((ResponseBody)closeable).source() : null;
        if (source == null) {
            throw (Throwable)new IOException("Message body or source from " + url + " was null");
        }
        File file = dest.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        Closeable closeable2 = Okio.buffer(Okio.sink(dest));
        Throwable throwable = null;
        try {
            BufferedSink it = (BufferedSink)closeable2;
            long l = it.writeAll(source);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable2, throwable);
        }
    }

    private InternetManager() {
    }

    static {
        InternetManager internetManager;
        INSTANCE = internetManager = new InternetManager();
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        if (okHttpClient == null) {
            Intrinsics.throwNpe();
        }
        httpClient = okHttpClient;
        urls = CollectionsKt.listOf("8.8.8.8", "1.1.1.1");
    }
}

