/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.tools;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;

public class RedstoneChannels
extends AbstractWorldData<RedstoneChannels> {
    private static final String REDSTONE_CHANNELS_NAME = "RfToolsRedstoneChannels";
    private int lastId = 0;
    private final Map<Integer, RedstoneChannel> channels = new HashMap<Integer, RedstoneChannel>();

    public RedstoneChannels(String name) {
        super(name);
    }

    public static RedstoneChannels getChannels(World world) {
        return (RedstoneChannels)RedstoneChannels.getData((World)world, () -> new RedstoneChannels(REDSTONE_CHANNELS_NAME), (String)REDSTONE_CHANNELS_NAME);
    }

    public RedstoneChannel getOrCreateChannel(int id) {
        RedstoneChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new RedstoneChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public RedstoneChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.channels.clear();
        ListNBT lst = tagCompound.func_150295_c("channels", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            int v = tc.func_74762_e("value");
            String name = tc.func_74779_i("name");
            RedstoneChannel value = new RedstoneChannel();
            value.value = v;
            value.setName(name);
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT lst = new ListNBT();
        for (Map.Entry<Integer, RedstoneChannel> entry : this.channels.entrySet()) {
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("channel", entry.getKey().intValue());
            tc.func_74768_a("value", entry.getValue().getValue());
            tc.func_74778_a("name", entry.getValue().getName());
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("channels", (INBT)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class RedstoneChannel {
        private int value = 0;
        private String name = "";

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

