/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.data;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.registry.condition.data.ConditionData;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionID;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionScope;
import java.util.Map;

public class ConditionDataContainer {
    private Map<ConditionID, ConditionData.BooleanCondition> bom = Maps.newHashMap();
    private Map<ConditionID, ConditionData.ByteCondition> bym = Maps.newHashMap();
    private Map<ConditionID, ConditionData.ShortCondition> shm = Maps.newHashMap();
    private Map<ConditionID, ConditionData.IntCondition> inm = Maps.newHashMap();
    private Map<ConditionID, ConditionData.LongCondition> lom = Maps.newHashMap();
    private Map<ConditionID, ConditionData.FloatCondition> flm = Maps.newHashMap();
    private Map<ConditionID, ConditionData.DoubleCondition> dom = Maps.newHashMap();
    private Map<ConditionID, ConditionData.StringCondition> stm = Maps.newHashMap();

    public ConditionData.BooleanCondition getBooleanCondition(ConditionID id) {
        return this.getCondition(id, this.bom, ConditionData.BooleanCondition.EMPTY);
    }

    public ConditionData.ByteCondition getByteCondition(ConditionID id) {
        return this.getCondition(id, this.bym, ConditionData.ByteCondition.EMPTY);
    }

    public ConditionData.ShortCondition getShortCondition(ConditionID id) {
        return this.getCondition(id, this.shm, ConditionData.ShortCondition.EMPTY);
    }

    public ConditionData.IntCondition getIntCondition(ConditionID id) {
        return this.getCondition(id, this.inm, ConditionData.IntCondition.EMPTY);
    }

    public ConditionData.LongCondition getLongCondition(ConditionID id) {
        return this.getCondition(id, this.lom, ConditionData.LongCondition.EMPTY);
    }

    public ConditionData.FloatCondition getFloatCondition(ConditionID id) {
        return this.getCondition(id, this.flm, ConditionData.FloatCondition.EMPTY);
    }

    public ConditionData.DoubleCondition getDoubleCondition(ConditionID id) {
        return this.getCondition(id, this.dom, ConditionData.DoubleCondition.EMPTY);
    }

    public ConditionData.StringCondition getStringCondition(ConditionID id) {
        return this.getCondition(id, this.stm, ConditionData.StringCondition.EMPTY);
    }

    private <T extends ConditionData> T getCondition(ConditionID id, Map<ConditionID, T> conditionMap, T empty) {
        if (conditionMap.containsKey(id)) {
            return (T)((ConditionData)conditionMap.get(id));
        }
        return empty;
    }

    public ConditionDataContainer copyScoped(ConditionScope scope) {
        Builder b = Builder.create();
        this.bom.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addBoolean(c.copy()));
        this.bym.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addByte(c.copy()));
        this.shm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addShort(c.copy()));
        this.inm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addInt(c.copy()));
        this.lom.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addLong(c.copy()));
        this.flm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addFloat(c.copy()));
        this.dom.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addDouble(c.copy()));
        this.stm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addString(c.copy()));
        return b.build();
    }

    public ConditionDataContainer copy() {
        Builder b = Builder.create();
        this.bom.values().forEach(c -> b.addBoolean(c.copy()));
        this.bym.values().forEach(c -> b.addByte(c.copy()));
        this.shm.values().forEach(c -> b.addShort(c.copy()));
        this.inm.values().forEach(c -> b.addInt(c.copy()));
        this.lom.values().forEach(c -> b.addLong(c.copy()));
        this.flm.values().forEach(c -> b.addFloat(c.copy()));
        this.dom.values().forEach(c -> b.addDouble(c.copy()));
        this.stm.values().forEach(c -> b.addString(c.copy()));
        return b.build();
    }

    public void reloadFromTemplate(ConditionDataContainer template, boolean deleteUnspecified) {
        this.bom.forEach((id, c) -> {
            ConditionData.BooleanCondition ct = template.bom.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.bym.forEach((id, c) -> {
            ConditionData.ByteCondition ct = template.bym.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.shm.forEach((id, c) -> {
            ConditionData.ShortCondition ct = template.shm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.inm.forEach((id, c) -> {
            ConditionData.IntCondition ct = template.inm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.lom.forEach((id, c) -> {
            ConditionData.LongCondition ct = template.lom.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.flm.forEach((id, c) -> {
            ConditionData.FloatCondition ct = template.flm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.dom.forEach((id, c) -> {
            ConditionData.DoubleCondition ct = template.dom.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.stm.forEach((id, c) -> {
            ConditionData.StringCondition ct = template.stm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
    }

    public static final class Builder {
        private Map<ConditionID, ConditionData.BooleanCondition> bom = Maps.newHashMap();
        private Map<ConditionID, ConditionData.ByteCondition> bym = Maps.newHashMap();
        private Map<ConditionID, ConditionData.ShortCondition> shm = Maps.newHashMap();
        private Map<ConditionID, ConditionData.IntCondition> inm = Maps.newHashMap();
        private Map<ConditionID, ConditionData.LongCondition> lom = Maps.newHashMap();
        private Map<ConditionID, ConditionData.FloatCondition> flm = Maps.newHashMap();
        private Map<ConditionID, ConditionData.DoubleCondition> dom = Maps.newHashMap();
        private Map<ConditionID, ConditionData.StringCondition> stm = Maps.newHashMap();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public void addBoolean(ConditionData.BooleanCondition condition) {
            if (condition != null) {
                this.bom.put(condition.id, condition);
            }
        }

        public void addByte(ConditionData.ByteCondition condition) {
            if (condition != null) {
                this.bym.put(condition.id, condition);
            }
        }

        public void addShort(ConditionData.ShortCondition condition) {
            if (condition != null) {
                this.shm.put(condition.id, condition);
            }
        }

        public void addInt(ConditionData.IntCondition condition) {
            if (condition != null) {
                this.inm.put(condition.id, condition);
            }
        }

        public void addLong(ConditionData.LongCondition condition) {
            if (condition != null) {
                this.lom.put(condition.id, condition);
            }
        }

        public void addFloat(ConditionData.FloatCondition condition) {
            if (condition != null) {
                this.flm.put(condition.id, condition);
            }
        }

        public void addDouble(ConditionData.DoubleCondition condition) {
            if (condition != null) {
                this.dom.put(condition.id, condition);
            }
        }

        public void addString(ConditionData.StringCondition condition) {
            if (condition != null) {
                this.stm.put(condition.id, condition);
            }
        }

        public ConditionDataContainer build() {
            ConditionDataContainer cdb = new ConditionDataContainer();
            cdb.bom = this.bom;
            cdb.bym = this.bym;
            cdb.shm = this.shm;
            cdb.inm = this.inm;
            cdb.lom = this.lom;
            cdb.flm = this.flm;
            cdb.dom = this.dom;
            cdb.stm = this.stm;
            return cdb;
        }
    }
}

