/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.wrapped;

import com.valkyrieofnight.vlib.core.debug.SimpleDebugger;
import com.valkyrieofnight.vlib.core.obj.block.base.color.IColoredBlock;
import com.valkyrieofnight.vlib.core.obj.item.base.color.IColoredItem;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.util.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.modloader.IMCRegistryClient;
import com.valkyrieofnight.vlib.core.util.modloader.forge.ForgeRegEventsClient;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistry;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;

public class VLRegistryClient
extends VLRegistry
implements IMCRegistryClient {
    protected ThemeRegistryClient THEME_REGISTRY;
    protected IMCRegistryClient REG_CLIENT;

    public VLRegistryClient(SimpleDebugger db, ThemeRegistryClient reg) {
        super(db, new ForgeRegEventsClient(db));
        this.THEME_REGISTRY = reg;
        this.REG_CLIENT = (ForgeRegEventsClient)this.REG;
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.REG);
    }

    public VLRegistryClient(SimpleDebugger db) {
        this(db, ThemeRegistryClient.getInstance());
    }

    public <M extends Container, U extends Screen> void registerScreenFactory(ContainerType<? extends M> containerType, ScreenManager.IScreenFactory<M, U> screenFactory) {
        ScreenManager.func_216911_a(containerType, screenFactory);
    }

    public void registerThemeAssets(ThemeID themeID, Action1a<Theme.ThemeAssetContainer> registerAssets) {
        if (themeID == null) {
            this.db.log("Tried registering ThemeAssets but themeID provided was null");
            return;
        }
        if (registerAssets == null) {
            this.db.log("Tried registering ThemeAssets but provided Action1a<Theme.ThemeAssetContainer> was null");
            return;
        }
        this.THEME_REGISTRY.addThemeAssetContainer(themeID, registerAssets);
    }

    @Override
    public void registerBlockColor(Block blk) {
        if (blk == null) {
            this.db.log("Tried registering BlockColor but it was null");
            return;
        }
        this.REG_CLIENT.registerBlockColor(blk);
    }

    @Override
    public void registerItemColor(Item itm) {
        if (itm == null) {
            this.db.log("Tried registering ItemColor but it was null");
            return;
        }
        this.REG_CLIENT.registerItemColor(itm);
    }

    @Override
    public void registerBlock(@NotNull Block block) {
        super.registerBlock(block);
        if (block instanceof IColoredBlock) {
            this.registerBlockColor(block);
        }
    }

    @Override
    public void registerItem(@NotNull Item item) {
        super.registerItem(item);
        if (item instanceof IColoredItem) {
            this.registerItemColor(item);
        }
    }

    @Override
    public ThemeRegistry getThemeRegistry() {
        return this.THEME_REGISTRY;
    }

    public void setRenderType(Block block, RenderType type) {
        this.REG_CLIENT.setRenderType(block, arg_0 -> ((RenderType)type).equals(arg_0));
    }

    public void setRenderType(Fluid fluid, RenderType type) {
        this.REG_CLIENT.setRenderType(fluid, arg_0 -> ((RenderType)type).equals(arg_0));
    }

    @Override
    public void setRenderType(Block block, Predicate<RenderType> predicate) {
        this.REG_CLIENT.setRenderType(block, predicate);
    }

    @Override
    public void setRenderType(Fluid fluid, Predicate<RenderType> predicate) {
        this.REG_CLIENT.setRenderType(fluid, predicate);
    }
}

