/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumSet;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.distribution.target.EnergyAcceptorTarget;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.EnumUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class CableUtils {
    public static IStrictEnergyHandler[] getConnectedAcceptors(BlockPos pos, World world, Set<Direction> sides) {
        IStrictEnergyHandler[] acceptors = new IStrictEnergyHandler[EnumUtils.DIRECTIONS.length];
        EmitUtils.forEachSide(world, pos, sides, (tile, side) -> {
            acceptors[side.ordinal()] = EnergyCompatUtils.getStrictEnergyHandler(tile, side.func_176734_d());
        });
        return acceptors;
    }

    public static void emit(IEnergyContainer energyContainer, TileEntity from) {
        CableUtils.emit(EnumSet.allOf(Direction.class), energyContainer, from);
    }

    public static void emit(Set<Direction> outputSides, IEnergyContainer energyContainer, TileEntity from) {
        CableUtils.emit(outputSides, energyContainer, from, energyContainer.getMaxEnergy());
    }

    public static void emit(Set<Direction> outputSides, IEnergyContainer energyContainer, TileEntity from, FloatingLong maxOutput) {
        if (!energyContainer.isEmpty() && !maxOutput.isZero()) {
            energyContainer.extract(CableUtils.emit(outputSides, energyContainer.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL), from), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static FloatingLong emit(Set<Direction> sides, FloatingLong energyToSend, TileEntity from) {
        if (energyToSend.isZero() || sides.isEmpty()) {
            return FloatingLong.ZERO;
        }
        EnergyAcceptorTarget target = new EnergyAcceptorTarget();
        EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> {
            Direction accessSide = side.func_176734_d();
            IStrictEnergyHandler strictEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(acceptor, accessSide);
            if (strictEnergyHandler != null) {
                target.addHandler(accessSide, strictEnergyHandler);
            }
        });
        int curHandlers = target.getHandlers().size();
        if (curHandlers > 0) {
            ObjectOpenHashSet targets = new ObjectOpenHashSet();
            targets.add(target);
            return EmitUtils.sendToAcceptors(targets, curHandlers, energyToSend);
        }
        return FloatingLong.ZERO;
    }
}

