/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.RotaryCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityRotaryCondensentrator
extends TileEntityMekanism
implements ITileCachedRecipeHolder<RotaryRecipe>,
IHasMode {
    private static final int CAPACITY = 10000;
    public BasicGasTank gasTank;
    public BasicFluidTank fluidTank;
    public boolean mode;
    public long gasOutput = 256L;
    private final IOutputHandler<@NonNull GasStack> gasOutputHandler;
    private final IOutputHandler<@NonNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private CachedRecipe<RotaryRecipe> cachedRecipe;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private MachineEnergyContainer<TileEntityRotaryCondensentrator> energyContainer;
    private GasInventorySlot gasInputSlot;
    private GasInventorySlot gasOutputSlot;
    private FluidInventorySlot fluidInputSlot;
    private OutputInventorySlot fluidOutputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityRotaryCondensentrator() {
        super(MekanismBlocks.ROTARY_CONDENSENTRATOR);
        this.gasInputHandler = InputHelper.getInputHandler(this.gasTank);
        this.fluidInputHandler = InputHelper.getInputHandler(this.fluidTank);
        this.gasOutputHandler = OutputHelper.getOutputHandler(this.gasTank);
        this.fluidOutputHandler = OutputHelper.getOutputHandler(this.fluidTank);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.gasTank = BasicGasTank.create(10000L, (gas, automationType) -> automationType == AutomationType.MANUAL || this.mode, (gas, automationType) -> automationType == AutomationType.INTERNAL || !this.mode, this::isValidGas, (IMekanismGasHandler)this);
        builder.addTank(this.gasTank, RelativeSide.LEFT);
        return builder.build();
    }

    private boolean isValidGas(@Nonnull Gas gas) {
        return this.containsRecipe(recipe -> recipe.hasGasToFluid() && recipe.getGasInput().testType(gas));
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.create(10000, (fluid, automationType) -> automationType == AutomationType.MANUAL || !this.mode, (fluid, automationType) -> automationType == AutomationType.INTERNAL || this.mode, this::isValidFluid, (IMekanismFluidHandler)this);
        builder.addTank(this.fluidTank, RelativeSide.RIGHT);
        return builder.build();
    }

    private boolean isValidFluid(@Nonnull FluidStack fluidStack) {
        return this.containsRecipe(recipe -> recipe.hasFluidToGas() && recipe.getFluidInput().testType(fluidStack));
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.gasInputSlot = GasInventorySlot.rotary(this.gasTank, () -> this.mode, this, 5, 25);
        builder.addSlot(this.gasInputSlot, RelativeSide.LEFT);
        this.gasOutputSlot = GasInventorySlot.rotary(this.gasTank, () -> this.mode, this, 5, 56);
        builder.addSlot(this.gasOutputSlot, RelativeSide.LEFT);
        this.fluidInputSlot = FluidInventorySlot.rotary(this.fluidTank, () -> this.mode, this, 155, 25);
        builder.addSlot(this.fluidInputSlot, RelativeSide.RIGHT);
        this.fluidOutputSlot = OutputInventorySlot.at(this, 155, 56);
        builder.addSlot(this.fluidOutputSlot, RelativeSide.RIGHT);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityRotaryCondensentrator)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot, RelativeSide.FRONT, RelativeSide.BACK, RelativeSide.BOTTOM, RelativeSide.TOP);
        this.gasInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.gasOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.gasOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidInputSlot.setSlotType(ContainerSlotType.INPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (this.mode) {
            this.fluidInputSlot.fillTank(this.fluidOutputSlot);
            this.gasInputSlot.drainTank();
            GasUtils.emit(EnumSet.of(this.getLeftSide()), this.gasTank, this, this.gasOutput);
        } else {
            this.gasOutputSlot.fillTank();
            this.fluidInputSlot.drainTank(this.fluidOutputSlot);
        }
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
    }

    @Override
    public void nextMode() {
        this.mode = !this.mode;
        this.markDirty(false);
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.mode = nbtTags.func_74767_n("mode");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("mode", this.mode);
        return nbtTags;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.mode) {
            return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
        }
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getCapacity());
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<RotaryRecipe> getRecipeType() {
        return MekanismRecipeType.ROTARY;
    }

    @Override
    @Nullable
    public CachedRecipe<RotaryRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public RotaryRecipe getRecipe(int cacheIndex) {
        if (this.mode) {
            FluidStack fluid = this.fluidInputHandler.getInput();
            if (fluid.isEmpty()) {
                return null;
            }
            return (RotaryRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid));
        }
        GasStack gas = this.gasInputHandler.getInput();
        if (gas.isEmpty()) {
            return null;
        }
        return (RotaryRecipe)this.findFirstRecipe(recipe -> recipe.test(gas));
    }

    public MachineEnergyContainer<TileEntityRotaryCondensentrator> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nullable
    public CachedRecipe<RotaryRecipe> createNewCachedRecipe(@Nonnull RotaryRecipe recipe, int cacheIndex) {
        return new RotaryCachedRecipe(recipe, this.fluidInputHandler, this.gasInputHandler, this.gasOutputHandler, this.fluidOutputHandler, () -> this.mode).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
            if (this.mode) {
                return Math.min(Math.min(this.fluidTank.getFluidAmount(), MathUtils.clampToInt(this.gasTank.getNeeded())), possibleProcess);
            }
            return Math.min(Math.min(MathUtils.clampToInt(this.gasTank.getStored()), this.fluidTank.getNeeded()), possibleProcess);
        });
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.mode, value -> {
            this.mode = value;
        }));
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

