/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GasToGasRecipeSerializer<T extends GasToGasRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public GasToGasRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        GasStackIngredient inputIngredient = GasStackIngredient.deserialize((JsonElement)input);
        GasStack output = SerializerHelper.getGasStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, inputIngredient, output);
    }

    public T read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            GasStackIngredient inputIngredient = GasStackIngredient.read(buffer);
            GasStack output = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, inputIngredient, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading gas to gas recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
        try {
            ((GasToGasRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing gas to gas recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends GasToGasRecipe> {
        public T create(ResourceLocation var1, GasStackIngredient var2, GasStack var3);
    }
}

