/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.machine.prefab.BlockTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.item.IItemSustainedInventory;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.security.ISecurityItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.OwnerDisplay;
import mekanism.common.util.text.UpgradeDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ItemBlockMachine
extends ItemBlockTooltip<BlockTile<?, ?>>
implements IItemSustainedInventory,
ISecurityItem {
    public ItemBlockMachine(BlockTile<?, ?> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1));
    }

    public ItemBlockMachine(BlockTile<?, ?> block, Supplier<Callable<ItemStackTileEntityRenderer>> renderer) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1).setISTER(renderer));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        tooltip.add(OwnerDisplay.of((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.getOwnerUUID(stack)).getTextComponent());
        if (Attribute.has(this.func_179223_d(), Attributes.AttributeSecurity.class)) {
            tooltip.add(MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity(stack, Dist.CLIENT)));
            if (SecurityUtils.isOverridden(stack, Dist.CLIENT)) {
                tooltip.add(MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
            }
        }
        StorageUtils.addStoredEnergy(stack, tooltip, false);
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        if (!fluidStack.isEmpty()) {
            tooltip.add(MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, new Object[]{fluidStack, EnumColor.GRAY, fluidStack.getAmount()}));
        }
        if (Attribute.has(this.func_179223_d(), Attributes.AttributeInventory.class)) {
            tooltip.add(MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))}));
        }
        if (Attribute.has(this.func_179223_d(), AttributeUpgradeSupport.class) && ItemDataUtils.hasData(stack, "upgrades", 9)) {
            Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getDataMap(stack));
            for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                tooltip.add(UpgradeDisplay.of(entry.getKey(), entry.getValue()).getTextComponent());
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (Attribute.has(this.func_179223_d(), AttributeEnergy.class)) {
            FloatingLong maxEnergy = MekanismUtils.getMaxEnergy(stack, Attribute.get(this.func_179223_d(), AttributeEnergy.class).getStorage());
            return new ItemCapabilityWrapper(stack, RateLimitEnergyHandler.create(() -> maxEnergy, BasicEnergyContainer.notExternal, BasicEnergyContainer.alwaysTrue));
        }
        return super.initCapabilities(stack, nbt);
    }
}

