/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlockCardboardBox
extends ItemBlockMekanism<BlockCardboardBox> {
    public ItemBlockCardboardBox(BlockCardboardBox block) {
        super(block, ItemDeferredRegister.getMekBaseProperties().func_200917_a(16));
        this.func_185043_a(Mekanism.rl("storage"), (stack, world, entity) -> this.getBlockData(stack) == null ? 0.0f : 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add(MekanismLang.BLOCK_DATA.translateColored(EnumColor.INDIGO, BooleanStateDisplay.YesNo.of(this.getBlockData(stack) != null)));
        BlockCardboardBox.BlockData data = this.getBlockData(stack);
        if (data != null) {
            try {
                tooltip.add((ITextComponent)MekanismLang.BLOCK.translate(data.blockState.func_177230_c()));
                if (data.tileTag != null) {
                    tooltip.add((ITextComponent)MekanismLang.TILE.translate(data.tileTag.func_74779_i("id")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nonnull
    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (stack.func_190926_b() || player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (this.getBlockData(stack) == null && !player.func_225608_bj_() && !world.func_175623_d(pos)) {
            BlockState state = world.func_180495_p(pos);
            if (!world.field_72995_K && state.func_185887_b((IBlockReader)world, pos) != -1.0f) {
                if (state.func_203425_a(MekanismTags.Blocks.CARDBOARD_BLACKLIST) || ((List)MekanismConfig.general.cardboardModBlacklist.get()).contains(state.func_177230_c().getRegistryName().func_110624_b())) {
                    return ActionResultType.FAIL;
                }
                BlockCardboardBox.BlockData data = new BlockCardboardBox.BlockData(state);
                TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos);
                if (tile != null) {
                    if (!SecurityUtils.canAccess(player, tile)) {
                        return ActionResultType.FAIL;
                    }
                    CompoundNBT tag = new CompoundNBT();
                    tile.func_189515_b(tag);
                    data.tileTag = tag;
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                CommonPlayerTracker.monitoringCardboardBox = true;
                world.func_217377_a(pos, false);
                world.func_175656_a(pos, (BlockState)((BlockCardboardBox)this.func_179223_d()).func_176223_P().func_206870_a((IProperty)BlockStateHelper.storageProperty, (Comparable)Boolean.valueOf(true)));
                CommonPlayerTracker.monitoringCardboardBox = false;
                TileEntityCardboardBox box = MekanismUtils.getTileEntity(TileEntityCardboardBox.class, (IBlockReader)world, pos);
                if (box != null) {
                    box.storedData = data;
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean func_195941_b(@Nonnull BlockItemUseContext context, @Nonnull BlockState state) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return true;
        }
        if (super.func_195941_b(context, state)) {
            TileEntityCardboardBox tile = MekanismUtils.getTileEntity(TileEntityCardboardBox.class, (IBlockReader)world, context.func_195995_a());
            if (tile != null) {
                tile.storedData = this.getBlockData(context.func_195996_i());
            }
            return true;
        }
        return false;
    }

    public void setBlockData(ItemStack stack, BlockCardboardBox.BlockData data) {
        ItemDataUtils.setCompound(stack, "data", data.write(new CompoundNBT()));
    }

    private BlockCardboardBox.BlockData getBlockData(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "data", 10)) {
            return BlockCardboardBox.BlockData.read(ItemDataUtils.getCompound(stack, "data"));
        }
        return null;
    }

    public int getItemStackLimit(ItemStack stack) {
        BlockCardboardBox.BlockData blockData = this.getBlockData(stack);
        if (blockData != null) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }
}

