/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.base.IUpgradeItem;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemUpgrade
extends Item
implements IUpgradeItem {
    private final Upgrade upgrade;

    public ItemUpgrade(Upgrade type, Item.Properties properties) {
        super(properties.func_200917_a(type.getMax()));
        this.upgrade = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.detailsKey)) {
            tooltip.add(this.getUpgradeType(stack).getDescription());
        } else {
            tooltip.add(MekanismLang.HOLD_FOR_DETAILS.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_197978_k()}));
        }
    }

    @Override
    public Upgrade getUpgradeType(ItemStack stack) {
        return this.upgrade;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            World world = context.func_195991_k();
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, context.func_195995_a());
            ItemStack stack = player.func_184586_b(context.func_221531_n());
            Upgrade type = this.getUpgradeType(stack);
            if (tile instanceof IUpgradeTile) {
                IUpgradeTile upgradeTile = (IUpgradeTile)tile;
                if (!upgradeTile.supportsUpgrades()) {
                    return ActionResultType.PASS;
                }
                TileComponentUpgrade component = upgradeTile.getComponent();
                if (component.supports(type) && !world.field_72995_K && component.getUpgrades(type) < type.getMax()) {
                    component.addUpgrade(type);
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }
}

