/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FuelInventorySlot
extends BasicInventorySlot {
    public static FuelInventorySlot forFuel(ToIntFunction<@NonNull ItemStack> fuelValue, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(fuelValue, "Fuel value calculator cannot be null");
        return new FuelInventorySlot(stack -> fuelValue.applyAsInt((ItemStack)stack) == 0, stack -> fuelValue.applyAsInt((ItemStack)stack) > 0, (Predicate<ItemStack>)alwaysTrue, inventory, x, y);
    }

    private FuelInventorySlot(Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        super((ItemStack stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((ItemStack)stack), (ItemStack stack, AutomationType automationType) -> canInsert.test((ItemStack)stack), validator, inventory, x, y);
    }

    public int burn() {
        if (this.isEmpty()) {
            return 0;
        }
        int burnTime = ForgeHooks.getBurnTime((ItemStack)this.current) / 2;
        if (burnTime > 0) {
            if (this.current.hasContainerItem()) {
                if (this.current.func_190916_E() > 1) {
                    return 0;
                }
                this.setStack(this.current.getContainerItem());
            } else {
                MekanismUtils.logMismatchedStackSize(this.shrinkStack(1, Action.EXECUTE), 1L);
            }
        }
        return burnTime;
    }
}

