/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.api.Pos3D;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFlame
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int LIFESPAN = 80;
    public static final int DAMAGE = 10;
    public Entity owner = null;
    public ItemFlamethrower.FlamethrowerMode mode = ItemFlamethrower.FlamethrowerMode.COMBAT;

    public EntityFlame(EntityType<EntityFlame> type, World world) {
        super(type, world);
    }

    public EntityFlame(PlayerEntity player) {
        this(MekanismEntityTypes.FLAME.getEntityType(), player.field_70170_p);
        Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.6, 0.0);
        Pos3D flameVec = new Pos3D(1.0, 1.0, 1.0);
        flameVec = flameVec.multiply(new Pos3D(player.func_70040_Z())).rotateYaw(6.0f);
        Pos3D mergedVec = playerPos.translate(flameVec);
        this.func_70107_b(mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c);
        Pos3D motion = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(player.func_70040_Z()));
        this.setHeading(motion);
        this.func_213317_d(motion);
        this.owner = player;
        this.mode = ((ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b()).getMode(player.field_71071_by.func_70448_g());
    }

    public void setHeading(Pos3D motion) {
        float d = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70126_B = this.field_70177_z = (float)Math.toDegrees(Math.atan2(motion.field_72450_a, motion.field_72449_c));
        this.field_70127_C = this.field_70125_A = (float)Math.toDegrees(Math.atan2(motion.field_72448_b, d));
    }

    public void func_70071_h_() {
        if (!this.func_70089_S()) {
            return;
        }
        ++this.field_70173_aa;
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        Vec3d motion = this.func_213322_ci();
        this.func_226288_n_(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.calculateVector();
        if (this.field_70173_aa > 80) {
            this.func_70106_y();
        }
    }

    private void calculateVector() {
        EntityRayTraceResult entityResult;
        Vec3d localVec = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vec3d motion = this.func_213322_ci();
        Vec3d motionVec = new Vec3d(this.func_226277_ct_() + motion.func_82615_a() * 2.0, this.func_226278_cu_() + motion.func_82617_b() * 2.0, this.func_226281_cx_() + motion.func_82616_c() * 2.0);
        BlockRayTraceResult blockRayTrace = this.field_70170_p.func_217299_a(new RayTraceContext(localVec, motionVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)this));
        localVec = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        motionVec = new Vec3d(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        if (blockRayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            motionVec = blockRayTrace.func_216347_e();
        }
        if ((entityResult = ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)localVec, (Vec3d)motionVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_72314_b(1.0, 1.0, 1.0), (Predicate)EntityPredicates.field_180132_d)) != null) {
            Entity entity = entityResult.func_216348_a();
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity.getEntity();
                if (player.field_71075_bZ.field_75102_a || this.owner instanceof PlayerEntity && !((PlayerEntity)this.owner).func_96122_a(player)) {
                    return;
                }
            }
            if (!entity.getEntity().func_70045_F()) {
                if (entity.getEntity() instanceof ItemEntity && this.mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                    if (entity.getEntity().field_70173_aa > 100 && !this.smeltItem((ItemEntity)entity.getEntity())) {
                        this.burn(entity.getEntity());
                    }
                } else {
                    this.burn(entity.getEntity());
                }
            }
            this.func_70106_y();
        } else if (blockRayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            boolean hitFluid;
            BlockPos hitPos = blockRayTrace.func_216350_a();
            Direction hitSide = blockRayTrace.func_216354_b();
            boolean bl = hitFluid = !this.field_70170_p.func_204610_c(hitPos).func_206888_e();
            if (!this.field_70170_p.field_72995_K && MekanismConfig.general.aestheticWorldDamage.get() && !hitFluid) {
                if (this.mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                    this.smeltBlock(hitPos);
                } else if (this.mode == ItemFlamethrower.FlamethrowerMode.INFERNO) {
                    PlayerEntity shooter;
                    BlockState hitState = this.field_70170_p.func_180495_p(hitPos);
                    BlockPos sidePos = hitPos.func_177972_a(hitSide);
                    BlockState sideState = this.field_70170_p.func_180495_p(sidePos);
                    PlayerEntity playerEntity = shooter = this.owner instanceof PlayerEntity ? (PlayerEntity)this.owner : null;
                    if (FlintAndSteelItem.func_219996_a((BlockState)sideState, (IWorld)this.field_70170_p, (BlockPos)sidePos)) {
                        this.field_70170_p.func_175656_a(sidePos, Blocks.field_150480_ab.func_176223_P());
                    } else if (FlintAndSteelItem.func_219997_a((BlockState)hitState)) {
                        this.field_70170_p.func_175656_a(hitPos, (BlockState)hitState.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                    } else if (hitState.isFlammable((IBlockReader)this.field_70170_p, hitPos, hitSide)) {
                        hitState.catchFire(this.field_70170_p, hitPos, hitSide, (LivingEntity)shooter);
                        if (hitState.func_177230_c() instanceof TNTBlock) {
                            this.field_70170_p.func_217377_a(hitPos, false);
                        }
                    }
                }
            }
            if (hitFluid) {
                this.spawnParticlesAt(this.func_180425_c());
                this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            }
            this.func_70106_y();
        }
    }

    private boolean smeltItem(ItemEntity item) {
        Optional recipe = this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{item.func_92059_d()}), this.field_70170_p);
        if (recipe.isPresent()) {
            ItemStack result = ((FurnaceRecipe)recipe.get()).func_77571_b();
            item.func_92058_a(StackUtils.size(result, item.func_92059_d().func_190916_E()));
            item.field_70173_aa = 0;
            this.spawnParticlesAt(item.func_180425_c());
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean smeltBlock(BlockPos blockPos) {
        Optional recipe;
        if (this.field_70170_p.func_175623_d(blockPos)) {
            return false;
        }
        ItemStack stack = new ItemStack((IItemProvider)this.field_70170_p.func_180495_p(blockPos).func_177230_c());
        if (stack.func_190926_b()) {
            return false;
        }
        try {
            recipe = this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_70170_p);
        }
        catch (Exception e) {
            return false;
        }
        if (recipe.isPresent()) {
            if (!this.field_70170_p.field_72995_K) {
                BlockState state = this.field_70170_p.func_180495_p(blockPos);
                ItemStack result = ((FurnaceRecipe)recipe.get()).func_77571_b();
                if (result.func_77973_b() instanceof BlockItem) {
                    this.field_70170_p.func_175656_a(blockPos, Block.func_149634_a((Item)result.func_77973_b().getItem()).func_176223_P());
                } else {
                    this.field_70170_p.func_217377_a(blockPos, false);
                    ItemEntity item = new ItemEntity(this.field_70170_p, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, result.func_77946_l());
                    item.func_213293_j(0.0, 0.0, 0.0);
                    this.field_70170_p.func_217376_c((Entity)item);
                }
                this.field_70170_p.func_217379_c(2001, blockPos, Block.func_196246_j((BlockState)state));
            }
            this.spawnParticlesAt(blockPos.func_177963_a(0.5, 0.5, 0.5));
            return true;
        }
        return false;
    }

    private void burn(Entity entity) {
        entity.func_70015_d(20);
        entity.func_70097_a(this.getFlamethrowerDamage(), 10.0f);
    }

    private DamageSource getFlamethrowerDamage() {
        if (this.owner == null) {
            return DamageSource.func_76356_a((Entity)this, (Entity)this);
        }
        return DamageSource.func_76356_a((Entity)this, (Entity)this.owner);
    }

    private void spawnParticlesAt(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + ((double)this.field_70146_Z.nextFloat() - 0.5), (double)pos.func_177956_o() + ((double)this.field_70146_Z.nextFloat() - 0.5), (double)pos.func_177952_p() + ((double)this.field_70146_Z.nextFloat() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent(nbtTags, "mode", ItemFlamethrower.FlamethrowerMode::byIndexStatic, mode -> {
            this.mode = mode;
        });
    }

    protected void func_213281_b(@Nonnull CompoundNBT nbtTags) {
        nbtTags.func_74768_a("mode", this.mode.ordinal());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer dataStream) {
        dataStream.func_179249_a((Enum)this.mode);
    }

    public void readSpawnData(PacketBuffer dataStream) {
        this.mode = (ItemFlamethrower.FlamethrowerMode)dataStream.func_179257_a(ItemFlamethrower.FlamethrowerMode.class);
    }
}

