/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.distribution.target;

import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.distribution.SplitInfo;
import mekanism.common.distribution.target.Target;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.GasNetwork;
import net.minecraft.util.Direction;

public class GasTransmitterSaveTarget
extends Target<IGridTransmitter<IGasHandler, GasNetwork, GasStack>, Long, GasStack> {
    private GasStack currentStored = GasStack.EMPTY;

    public GasTransmitterSaveTarget(@Nonnull GasStack type) {
        this.extra = type;
    }

    @Override
    protected void acceptAmount(IGridTransmitter<IGasHandler, GasNetwork, GasStack> transmitter, SplitInfo<Long> splitInfo, Long amount) {
        amount = Math.min(amount, transmitter.getCapacity() - this.currentStored.getAmount());
        GasStack newGas = new GasStack((GasStack)this.extra, (long)amount);
        if (this.currentStored.isEmpty()) {
            this.currentStored = newGas;
        } else {
            this.currentStored.grow(amount);
        }
        splitInfo.send(amount);
    }

    @Override
    protected Long simulate(IGridTransmitter<IGasHandler, GasNetwork, GasStack> transmitter, @Nonnull GasStack gasStack) {
        if (!this.currentStored.isEmpty() && !this.currentStored.isTypeEqual(gasStack)) {
            return 0L;
        }
        return Math.min(gasStack.getAmount(), transmitter.getCapacity() - this.currentStored.getAmount());
    }

    public void saveShare(Direction handlerDirection) {
        TileEntityTransmitter tile;
        IGridTransmitter transmitter = (IGridTransmitter)this.handlers.get(handlerDirection);
        if (transmitter instanceof TransmitterImpl && (tile = ((TransmitterImpl)transmitter).getTileEntity()) instanceof TileEntityPressurizedTube) {
            TileEntityPressurizedTube tube = (TileEntityPressurizedTube)tile;
            if (this.currentStored.isEmpty() != tube.lastWrite.isEmpty() || !this.currentStored.isEmpty() && !this.currentStored.isStackIdentical(tube.lastWrite)) {
                tube.lastWrite = this.currentStored;
                tube.markDirty(false);
            }
        }
    }
}

