/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedConfigValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class GeneralConfig
extends BaseMekanismConfig {
    private static final String CONVERSION_CATEGORY = "energy_conversion";
    private static final String MINER_CATEGORY = "digital_miner";
    private static final String LASER_SETTINGS = "laser";
    private static final String PUMP_CATEGORY = "pump";
    private static final String ENTANGLOPORTER_CATEGORY = "quantum_entangloporter";
    private static final String SECURITY_CATEGORY = "security";
    private static final String EVAPORATION_CATEGORY = "thermal_evaporation";
    private final ForgeConfigSpec configSpec;
    public final CachedBooleanValue logPackets;
    public final CachedBooleanValue allowChunkloading;
    public final CachedIntValue blockDeactivationDelay;
    public final CachedConfigValue<List<String>> cardboardModBlacklist;
    public final CachedBooleanValue prefilledGasTanks;
    public final CachedBooleanValue transmitterAlloyUpgrade;
    public final CachedIntValue maxUpgradeMultiplier;
    public final CachedDoubleValue boilerWaterConductivity;
    public final CachedDoubleValue heatPerFuelTick;
    public final CachedDoubleValue resistiveHeaterEfficiency;
    public final CachedDoubleValue superheatingHeatTransfer;
    public final CachedEnumValue<UnitDisplayUtils.TempType> tempUnit;
    public final CachedBooleanValue blacklistIC2;
    public final CachedFloatingLongValue FROM_IC2;
    public final CachedFloatingLongValue TO_IC2;
    public final CachedBooleanValue blacklistForge;
    public final CachedFloatingLongValue FROM_FORGE;
    public final CachedFloatingLongValue TO_FORGE;
    public final CachedBooleanValue blacklistFluxNetworks;
    public final CachedFloatingLongValue FROM_H2;
    public final CachedIntValue ETHENE_BURN_TIME;
    public final CachedFloatingLongValue maxEnergyPerSteam;
    public final CachedEnumValue<UnitDisplayUtils.EnergyType> energyUnit;
    public final CachedIntValue minerSilkMultiplier;
    public final CachedIntValue minerMaxRadius;
    public final CachedIntValue minerTicksPerMine;
    public final CachedBooleanValue aestheticWorldDamage;
    public final CachedIntValue laserRange;
    public final CachedFloatingLongValue laserEnergyNeededPerHardness;
    public final CachedFloatingLongValue laserEnergyPerDamage;
    public final CachedIntValue maxPumpRange;
    public final CachedBooleanValue pumpWaterSources;
    public final CachedIntValue maxPlenisherNodes;
    public final CachedFloatingLongValue entangloporterEnergyBuffer;
    public final CachedIntValue entangloporterFluidBuffer;
    public final CachedLongValue entangloporterGasBuffer;
    public final CachedBooleanValue allowProtection;
    public final CachedBooleanValue opsBypassRestrictions;
    public final CachedDoubleValue evaporationHeatDissipation;
    public final CachedDoubleValue evaporationTempMultiplier;
    public final CachedDoubleValue evaporationSolarMultiplier;
    public final CachedDoubleValue evaporationHeatCapacity;

    GeneralConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General Config. This config is synced from server to client.").push("general");
        this.logPackets = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Log Mekanism packet names. Debug setting.").define("logPackets", false));
        this.allowChunkloading = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Disable to make the anchor upgrade not do anything.").define("allowChunkloading", true));
        this.blockDeactivationDelay = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("How many ticks must pass until a block's active state is synced with the client, if it has been rapidly changing.").define("blockDeactivationDelay", (Object)60));
        this.cardboardModBlacklist = CachedConfigValue.wrap(this, builder.comment("Any mod ids added to this list will not be able to have any of their blocks, picked up by the cardboard box.").define("cardboardModBlacklist", new ArrayList()));
        this.prefilledGasTanks = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Add filled creative gas tanks to creative/JEI.").define("prefilledGasTanks", true));
        this.transmitterAlloyUpgrade = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Allow right clicking on Cables/Pipes/Tubes with alloys to upgrade the tier.").define("transmitterAlloyUpgrade", true));
        this.maxUpgradeMultiplier = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Base factor for working out machine performance with upgrades - UpgradeModifier * (UpgradesInstalled/UpgradesPossible).").defineInRange("maxUpgradeMultiplier", 10, 1, Integer.MAX_VALUE));
        this.boilerWaterConductivity = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("How much Boiler heat is immediately usable to convert water to steam.").define("boilerWaterConductivity", (Object)0.7));
        this.heatPerFuelTick = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Amount of heat produced per fuel tick of a fuel's burn time in the Fuelwood Heater.").define("heatPerFuelTick", (Object)400.0));
        this.resistiveHeaterEfficiency = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("How much heat energy is created from one Joule of regular energy in the Resistive Heater.").defineInRange("resistiveHeaterEfficiency", 0.6, 0.0, 1.0));
        this.superheatingHeatTransfer = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Amount of heat each Boiler heating element produces.").define("superheatingHeatTransfer", (Object)512000.0));
        this.tempUnit = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Displayed temperature unit in Mekanism GUIs.").defineEnum("temperatureUnit", (Enum)UnitDisplayUtils.TempType.K));
        builder.comment("Energy Conversion Rate Settings").push(CONVERSION_CATEGORY);
        this.blacklistIC2 = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Disables IC2 power integration. Requires world restart (server-side option in SMP).").worldRestart().define("blacklistIC2", false));
        this.FROM_IC2 = CachedFloatingLongValue.define((IMekanismConfig)this, builder, "Conversion multiplier from EU to Joules (EU * JoulePerEU = Joules)", "JoulePerEU", FloatingLong.createConst(10L), CachedFloatingLongValue.POSITIVE);
        this.TO_IC2 = CachedFloatingLongValue.define((IMekanismConfig)this, builder, "Conversion multiplier from Joules to EU (Joules * EUPerJoule = EU)", "EUPerJoule", FloatingLong.createConst(0.1), CachedFloatingLongValue.POSITIVE);
        this.blacklistForge = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Disables Forge Energy (FE,RF,IF,uF,CF) power integration. Requires world restart (server-side option in SMP).").worldRestart().define("blacklistForge", false));
        this.FROM_FORGE = CachedFloatingLongValue.define((IMekanismConfig)this, builder, "Conversion multiplier from Forge Energy to Joules (FE * JoulePerForgeEnergy = Joules)", "JoulePerForgeEnergy", FloatingLong.createConst(2.5), CachedFloatingLongValue.POSITIVE);
        this.TO_FORGE = CachedFloatingLongValue.define((IMekanismConfig)this, builder, "Conversion multiplier from Joules to Forge Energy (Joules * ForgeEnergyPerJoule = FE)", "ForgeEnergyPerJoule", FloatingLong.createConst(0.4), CachedFloatingLongValue.POSITIVE);
        this.blacklistFluxNetworks = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Disables Flux Networks higher throughput Forge Energy (FE,RF,IF,uF,CF) power integration. Requires world restart (server-side option in SMP). Note: Disabling Forge Energy integration also disables this.").worldRestart().define("blacklistFluxNetworks", false));
        this.FROM_H2 = CachedFloatingLongValue.define((IMekanismConfig)this, builder, "How much energy is produced per mB of Hydrogen, also affects Electrolytic Separator usage, Ethylene burn rate and Gas generator energy capacity.", "HydrogenEnergyDensity", FloatingLong.createConst(200L), CachedFloatingLongValue.POSITIVE);
        this.ETHENE_BURN_TIME = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Burn time for Ethylene (1mB hydrogen + 2*bioFuel/tick*200ticks/100mB * 20x efficiency bonus).").define("EthyleneBurnTime", (Object)40));
        this.maxEnergyPerSteam = CachedFloatingLongValue.define(this, builder, "Maximum Joules per mB of Steam. Also affects Thermoelectric Boiler.", "maxEnergyPerSteam", FloatingLong.createConst(10L));
        this.energyUnit = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Displayed energy type in Mekanism GUIs.").defineEnum("energyType", (Enum)UnitDisplayUtils.EnergyType.FE));
        builder.pop();
        builder.comment("Digital Miner Settings").push(MINER_CATEGORY);
        this.minerSilkMultiplier = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Energy multiplier for using silk touch mode with the Digital Miner.").define("silkMultiplier", (Object)6));
        this.minerMaxRadius = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Maximum radius in blocks that the Digital Miner can reach. (Increasing this may have negative effects on stability and/or performance. We strongly recommend you leave it at the default value).").defineInRange("maxRadius", 32, 1, Integer.MAX_VALUE));
        this.minerTicksPerMine = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Number of ticks required to mine a single block with a Digital Miner (without any upgrades).").defineInRange("ticksPerMine", 80, 1, Integer.MAX_VALUE));
        builder.pop();
        builder.comment("Laser Settings").push(LASER_SETTINGS);
        this.aestheticWorldDamage = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If enabled, lasers can break blocks and the flamethrower starts fires.").define("aestheticWorldDamage", true));
        this.laserRange = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("How far (in blocks) a laser can travel.").define("range", (Object)64));
        this.laserEnergyNeededPerHardness = CachedFloatingLongValue.define(this, builder, "Energy needed to destroy or attract blocks with a Laser (per block hardness level).", "energyNeededPerHardness", FloatingLong.createConst(100000L));
        this.laserEnergyPerDamage = CachedFloatingLongValue.define((IMekanismConfig)this, builder, "Energy used per half heart of damage being transferred to entities.", "energyPerDamage", FloatingLong.createConst(2500L), CachedFloatingLongValue.POSITIVE);
        builder.pop();
        builder.comment("Pump Settings").push(PUMP_CATEGORY);
        this.maxPumpRange = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Maximum block distance to pull fluid from for the Electric Pump.").define("maxPumpRange", (Object)80));
        this.pumpWaterSources = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If enabled makes Water and Heavy Water blocks be removed from the world on pump.").define("pumpWaterSources", false));
        this.maxPlenisherNodes = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Fluidic Plenisher stops after this many blocks.").define("maxPlenisherNodes", (Object)4000));
        builder.pop();
        builder.comment("Quantum Entangloporter Settings").push(ENTANGLOPORTER_CATEGORY);
        this.entangloporterEnergyBuffer = CachedFloatingLongValue.define(this, builder, "Maximum energy buffer (Mekanism Joules) of an Entangoloporter frequency - i.e. the maximum transfer per tick per frequency. Default is ultimate tier energy cube capacity.", "energyBuffer", EnergyCubeTier.ULTIMATE.getBaseMaxEnergy(), true, CachedFloatingLongValue.POSITIVE);
        this.entangloporterFluidBuffer = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Maximum fluid buffer (mb) of an Entangoloporter frequency - i.e. the maximum transfer per tick per frequency. Default is ultimate tier tank capacity.").worldRestart().defineInRange("fluidBuffer", FluidTankTier.ULTIMATE.getBaseStorage(), 1, Integer.MAX_VALUE));
        this.entangloporterGasBuffer = CachedLongValue.wrap(this, (ForgeConfigSpec.ConfigValue<Long>)builder.comment("Maximum gas buffer (mb) of an Entangoloporter frequency - i.e. the maximum transfer per tick per frequency. Default is ultimate tier tank capacity.").worldRestart().defineInRange("gasBuffer", GasTankTier.ULTIMATE.getBaseStorage(), 1L, Long.MAX_VALUE));
        builder.pop();
        builder.comment("Block security/protection Settings").push(SECURITY_CATEGORY);
        this.allowProtection = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enable the security system for players to prevent others from accessing their machines. Does NOT affect Frequencies.").define("allowProtection", true));
        this.opsBypassRestrictions = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Ops can bypass the block security restrictions if enabled.").define("opsBypassRestrictions", false));
        builder.pop();
        builder.comment("Thermal Evaporation Plant Settings").push(EVAPORATION_CATEGORY);
        this.evaporationHeatDissipation = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Thermal Evaporation Tower heat loss per tick.").define("heatDissipation", (Object)0.02));
        this.evaporationTempMultiplier = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Temperature to amount produced ratio for Thermal Evaporation Tower.").define("tempMultiplier", (Object)0.1));
        this.evaporationSolarMultiplier = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Heat to absorb per Solar Panel array of Thermal Evaporation Tower.").define("solarMultiplier", (Object)0.2));
        this.evaporationHeatCapacity = CachedDoubleValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Heat capacity of Thermal Evaporation Tower layers (increases amount of energy needed to increase temperature).").define("heatCapacity", (Object)100.0));
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "general";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

