/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.resolver.advanced;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AdvancedCapabilityResolver
implements ICapabilityResolver {
    private final List<Capability<?>> supportedCapability;
    private final NonNullSupplier<?> supplier;
    private final NonNullSupplier<?> readOnlySupplier;
    private LazyOptional<?> cachedCapability;
    private LazyOptional<?> cachedReadOnlyCapability;

    public static <T> AdvancedCapabilityResolver create(Capability<T> supportedCapability, NonNullSupplier<T> supplier, NonNullSupplier<T> readOnlySupplier) {
        return new AdvancedCapabilityResolver(supportedCapability, supplier, readOnlySupplier);
    }

    public static <T> AdvancedCapabilityResolver readOnly(Capability<T> supportedCapability, T value, NonNullSupplier<T> readOnlySupplier) {
        return AdvancedCapabilityResolver.create(supportedCapability, () -> value, NonNullLazy.of(readOnlySupplier));
    }

    protected <T> AdvancedCapabilityResolver(Capability<T> supportedCapability, NonNullSupplier<T> supplier, NonNullSupplier<T> readOnlySupplier) {
        this.supportedCapability = Collections.singletonList(supportedCapability);
        this.supplier = supplier;
        this.readOnlySupplier = readOnlySupplier;
    }

    @Override
    public List<Capability<?>> getSupportedCapabilities() {
        return this.supportedCapability;
    }

    @Override
    public <T> LazyOptional<T> resolve(Capability<T> capability, @Nullable Direction side) {
        if (side == null) {
            if (this.cachedReadOnlyCapability == null || !this.cachedReadOnlyCapability.isPresent()) {
                this.cachedReadOnlyCapability = LazyOptional.of(this.readOnlySupplier);
            }
            return this.cachedReadOnlyCapability.cast();
        }
        if (this.cachedCapability == null || !this.cachedCapability.isPresent()) {
            this.cachedCapability = LazyOptional.of(this.supplier);
        }
        return this.cachedCapability.cast();
    }

    @Override
    public void invalidate(Capability<?> capability, @Nullable Direction side) {
        if (side == null) {
            this.invalidateReadOnly();
        } else {
            this.invalidate();
        }
    }

    @Override
    public void invalidateAll() {
        this.invalidate();
        this.invalidateReadOnly();
    }

    private void invalidateReadOnly() {
        if (this.cachedReadOnlyCapability != null && this.cachedReadOnlyCapability.isPresent()) {
            this.cachedReadOnlyCapability.invalidate();
            this.cachedReadOnlyCapability = null;
        }
    }

    private void invalidate() {
        if (this.cachedCapability != null && this.cachedCapability.isPresent()) {
            this.cachedCapability.invalidate();
            this.cachedCapability = null;
        }
    }
}

