/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.fluid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import net.minecraft.util.Direction;

public class FluidTankHolder
implements IFluidTankHolder {
    private final Map<RelativeSide, List<IExtendedFluidTank>> directionalTanks = new EnumMap<RelativeSide, List<IExtendedFluidTank>>(RelativeSide.class);
    private final List<IExtendedFluidTank> tanks = new ArrayList<IExtendedFluidTank>();
    private final Supplier<Direction> facingSupplier;

    FluidTankHolder(Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
    }

    void addTank(@Nonnull IExtendedFluidTank tank, RelativeSide ... sides) {
        this.tanks.add(tank);
        for (RelativeSide side : sides) {
            this.directionalTanks.computeIfAbsent(side, k -> new ArrayList()).add(tank);
        }
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getTanks(@Nullable Direction direction) {
        if (direction == null || this.directionalTanks.isEmpty()) {
            return this.tanks;
        }
        RelativeSide side = RelativeSide.fromDirections(this.facingSupplier.get(), direction);
        List<IExtendedFluidTank> tanks = this.directionalTanks.get((Object)side);
        if (tanks == null) {
            return Collections.emptyList();
        }
        return tanks;
    }
}

