/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import mekanism.client.model.ModelFluidTank;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.item.ItemLayerWrapper;
import mekanism.client.render.item.MekanismItemStackRenderer;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RenderFluidTankItem
extends MekanismItemStackRenderer {
    public static ItemLayerWrapper model;
    private static ModelFluidTank modelFluidTank;
    private static FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids;
    private static int stages;

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
    }

    @Override
    public void renderBlockSpecific(@Nonnull ItemStack stack, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, ItemCameraTransforms.TransformType transformType) {
        float fluidScale;
        FluidTankTier tier = ((ItemBlockFluidTank)stack.func_77973_b()).getTier();
        FluidStack fluid = StorageUtils.getStoredFluidFromNBT(stack);
        if (!fluid.isEmpty() && (fluidScale = (float)fluid.getAmount() / (float)tier.getStorage()) > 0.0f) {
            int color;
            int modelNumber;
            matrix.func_227860_a_();
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
            if (fluid.getFluid().getAttributes().isGaseous(fluid)) {
                modelNumber = stages - 1;
                color = MekanismRenderer.getColorARGB(fluid, fluidScale);
            } else {
                modelNumber = Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)));
                color = MekanismRenderer.getColorARGB(fluid);
            }
            MekanismRenderer.renderObject(this.getFluidModel(fluid, modelNumber), matrix, renderer.getBuffer(MekanismRenderType.resizableCuboid()), color, MekanismRenderer.calculateGlowLight(light, fluid));
            matrix.func_227865_b_();
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -0.9, 0.0);
        matrix.func_227862_a_(0.9f, 0.8f, 0.9f);
        matrix.func_227862_a_(1.168f, 1.168f, 1.168f);
        matrix.func_227861_a_(0.0, -0.06, 0.0);
        modelFluidTank.render(matrix, renderer, light, overlayLight, tier);
        matrix.func_227865_b_();
    }

    private MekanismRenderer.Model3D getFluidModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedCenterFluids.containsKey(fluid) && ((Int2ObjectMap)cachedCenterFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedCenterFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.135;
            model.minY = 0.0725;
            model.minZ = 0.135;
            model.maxX = 0.865;
            model.maxY = 0.0625 + (double)((float)stage / (float)stages) * 0.875 - 0.01;
            model.maxZ = 0.865;
        }
        if (cachedCenterFluids.containsKey(fluid)) {
            ((Int2ObjectMap)cachedCenterFluids.get(fluid)).put(stage, (Object)model);
        } else {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            map.put(stage, (Object)model);
            cachedCenterFluids.put(fluid, map);
        }
        return model;
    }

    @Override
    protected void renderItemSpecific(@Nonnull ItemStack stack, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, ItemCameraTransforms.TransformType transformType) {
    }

    @Override
    @Nonnull
    protected ItemCameraTransforms.TransformType getTransform(@Nonnull ItemStack stack) {
        return model.getTransform();
    }

    static {
        modelFluidTank = new ModelFluidTank();
        cachedCenterFluids = new FluidRenderMap();
        stages = 1400;
    }
}

