/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongConsumer;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.recipes.MekanismRecipe;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CachedRecipe<RECIPE extends MekanismRecipe> {
    protected final RECIPE recipe;
    private BooleanSupplier canHolderFunction = () -> true;
    private BooleanConsumer setActive = active -> {};
    private IntSupplier requiredTicks = () -> 1;
    private Runnable onFinish = () -> {};
    private FloatingLongSupplier perTickEnergy = () -> FloatingLong.ZERO;
    private FloatingLongSupplier storedEnergy = () -> FloatingLong.ZERO;
    private FloatingLongConsumer useEnergy = energy -> {};
    private IntUnaryOperator postProcessOperations = currentMax -> Math.min(1, currentMax);
    private int operatingTicks;
    private IntConsumer operatingTicksChanged = ticks -> {};

    protected CachedRecipe(RECIPE recipe) {
        this.recipe = recipe;
    }

    public CachedRecipe<RECIPE> setCanHolderFunction(BooleanSupplier canHolderFunction) {
        this.canHolderFunction = canHolderFunction;
        return this;
    }

    public CachedRecipe<RECIPE> setActive(BooleanConsumer setActive) {
        this.setActive = setActive;
        return this;
    }

    public CachedRecipe<RECIPE> setEnergyRequirements(FloatingLongSupplier perTickEnergy, IEnergyContainer energyContainer) {
        this.perTickEnergy = perTickEnergy;
        this.storedEnergy = energyContainer::getEnergy;
        this.useEnergy = energy -> energyContainer.extract(energy, Action.EXECUTE, AutomationType.INTERNAL);
        return this;
    }

    public CachedRecipe<RECIPE> setRequiredTicks(IntSupplier requiredTicks) {
        this.requiredTicks = requiredTicks;
        return this;
    }

    public CachedRecipe<RECIPE> setOperatingTicksChanged(IntConsumer operatingTicksChanged) {
        this.operatingTicksChanged = operatingTicksChanged;
        return this;
    }

    public CachedRecipe<RECIPE> setOnFinish(Runnable onFinish) {
        this.onFinish = onFinish;
        return this;
    }

    public CachedRecipe<RECIPE> setPostProcessOperations(IntUnaryOperator postProcessOperations) {
        this.postProcessOperations = postProcessOperations;
        return this;
    }

    public void loadSavedOperatingTicks(int operatingTicks) {
        if (operatingTicks > 0 && operatingTicks < this.getTicksRequired()) {
            this.operatingTicks = operatingTicks;
        }
    }

    public void process() {
        int operations;
        int n = operations = this.canHolderFunction() ? this.postProcessOperations.applyAsInt(this.getOperationsThisTick(Integer.MAX_VALUE)) : 0;
        if (operations > 0) {
            this.setActive.accept(true);
            this.useEnergy(operations);
            ++this.operatingTicks;
            int ticksRequired = this.getTicksRequired();
            if (this.operatingTicks >= ticksRequired) {
                this.operatingTicks = 0;
                this.finishProcessing(operations);
                this.onFinish.run();
            } else {
                this.useResources(operations);
            }
            if (ticksRequired > 1) {
                this.operatingTicksChanged.accept(this.operatingTicks);
            }
        } else {
            this.setActive.accept(false);
            if (operations < 0) {
                this.operatingTicks = 0;
                this.operatingTicksChanged.accept(this.operatingTicks);
            }
        }
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    private boolean canHolderFunction() {
        return this.canHolderFunction.getAsBoolean();
    }

    protected FloatingLong getStoredElectricity() {
        return this.storedEnergy.get();
    }

    @Nonnull
    protected FloatingLong getEnergyPerTick() {
        return this.perTickEnergy.get();
    }

    private int getTicksRequired() {
        return this.requiredTicks.getAsInt();
    }

    protected void useResources(int operations) {
    }

    protected void useEnergy(int operations) {
        this.useEnergy.accept(this.getEnergyPerTick().multiply(operations));
    }

    protected int getOperationsThisTick(int currentMax) {
        if (currentMax <= 0) {
            return currentMax;
        }
        FloatingLong energyPerTick = this.getEnergyPerTick();
        if (energyPerTick.isZero()) {
            return currentMax;
        }
        return Math.min(this.getStoredElectricity().divide(energyPerTick).intValue(), currentMax);
    }

    public boolean canFunction() {
        return this.canHolderFunction() && this.postProcessOperations.applyAsInt(this.getOperationsThisTick(1)) > 0;
    }

    public abstract boolean isInputValid();

    protected abstract void finishProcessing(int var1);

    public RECIPE getRecipe() {
        return this.recipe;
    }
}

