/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemShovel
extends ShovelItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemShovel(String baseName, IItemTier material, float damage, float speed) {
        super(material, damage, speed, new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.add(this);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this == ModItems.INFUSED_IRON_SHOVEL) {
            PlayerEntity player = context.func_195999_j();
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            ItemStack stack = player.func_184586_b(context.func_221531_n());
            BlockState state = world.func_180495_p(pos);
            int damage = 0;
            if (state.func_177230_c() == Blocks.field_150346_d) {
                if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
                    world.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                    damage = 5;
                }
            } else {
                int range = player.func_225608_bj_() ? 0 : 1;
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        Direction facing;
                        BlockPos actualPos = pos.func_177982_a(x, 0, y);
                        if (!player.func_175151_a(actualPos.func_177972_a(facing = context.func_196000_l()), facing, stack) || facing == Direction.DOWN || world.func_180495_p(actualPos.func_177984_a()).func_185904_a() != Material.field_151579_a || world.func_180495_p(actualPos).func_177230_c() != Blocks.field_150349_c) continue;
                        if (!world.field_72995_K) {
                            world.func_180501_a(actualPos, Blocks.field_185774_da.func_176223_P(), 11);
                        }
                        damage = 1;
                    }
                }
            }
            if (damage > 0) {
                world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_222118_a(damage, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (this == ModItems.INFUSED_IRON_SHOVEL) {
            return Helper.makeRechargeProvider(stack, true);
        }
        return null;
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

