/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.aura.type.BasicAuraType;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.api.misc.WeightedOre;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public final class NaturesAuraAPI {
    public static final String MOD_ID = "naturesaura";
    public static final String API_ID = "naturesauraapi";
    public static final String VERSION = "9";
    public static final BiMap<BlockState, BlockState> BOTANIST_PICKAXE_CONVERSIONS = HashBiMap.create();
    public static final Map<ResourceLocation, IAuraType> AURA_TYPES = new HashMap<ResourceLocation, IAuraType>();
    public static final BasicAuraType TYPE_OVERWORLD = new BasicAuraType(new ResourceLocation("naturesaura", "overworld"), DimensionType.field_223227_a_, 9030711, 0).register();
    public static final BasicAuraType TYPE_NETHER = new BasicAuraType(new ResourceLocation("naturesaura", "nether"), DimensionType.field_223228_b_, 8854540, 0).register();
    public static final BasicAuraType TYPE_END = new BasicAuraType(new ResourceLocation("naturesaura", "end"), DimensionType.field_223229_c_, 3155492, 0).register();
    public static final BasicAuraType TYPE_OTHER = new BasicAuraType(new ResourceLocation("naturesaura", "other"), null, 3123360, Integer.MIN_VALUE).register();
    public static final Map<ResourceLocation, Supplier<IDrainSpotEffect>> DRAIN_SPOT_EFFECTS = new HashMap<ResourceLocation, Supplier<IDrainSpotEffect>>();
    public static final Map<ResourceLocation, Integer> EFFECT_POWDERS = new HashMap<ResourceLocation, Integer>();
    public static final Map<ResourceLocation, IMultiblock> MULTIBLOCKS = new HashMap<ResourceLocation, IMultiblock>();
    public static final List<WeightedOre> OVERWORLD_ORES = new ArrayList<WeightedOre>();
    public static final List<WeightedOre> NETHER_ORES = new ArrayList<WeightedOre>();
    public static final Map<EntityType, Integer> PROJECTILE_GENERATIONS = new HashMap<EntityType, Integer>();
    @CapabilityInject(value=IAuraContainer.class)
    public static Capability<IAuraContainer> capAuraContainer;
    @CapabilityInject(value=IAuraRecharge.class)
    public static Capability<IAuraRecharge> capAuraRecharge;
    @CapabilityInject(value=IAuraChunk.class)
    public static Capability<IAuraChunk> capAuraChunk;
    @CapabilityInject(value=IWorldData.class)
    public static Capability<IWorldData> capWorldData;
    private static IInternalHooks instance;

    public static IInternalHooks instance() {
        return instance;
    }

    public static void setInstance(IInternalHooks inst) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = inst;
    }

    public static interface IInternalHooks {
        public boolean extractAuraFromPlayer(PlayerEntity var1, int var2, boolean var3);

        public boolean insertAuraIntoPlayer(PlayerEntity var1, int var2, boolean var3);

        public void spawnMagicParticle(double var1, double var3, double var5, double var7, double var9, double var11, int var13, float var14, int var15, float var16, boolean var17, boolean var18);

        public void spawnParticleStream(float var1, float var2, float var3, float var4, float var5, float var6, float var7, int var8, float var9);

        public void setParticleDepth(boolean var1);

        public void setParticleSpawnRange(int var1);

        public void setParticleCulling(boolean var1);

        public IMultiblock createMultiblock(ResourceLocation var1, String[][] var2, Object ... var3);

        public List<Tuple<Vec3d, Integer>> getActiveEffectPowders(World var1, AxisAlignedBB var2, ResourceLocation var3);

        public boolean isEffectPowderActive(World var1, BlockPos var2, ResourceLocation var3);

        public void getAuraSpotsInArea(World var1, BlockPos var2, int var3, BiConsumer<BlockPos, Integer> var4);

        public int getSpotAmountInArea(World var1, BlockPos var2, int var3);

        public int getAuraInArea(World var1, BlockPos var2, int var3);

        public int triangulateAuraInArea(World var1, BlockPos var2, int var3);

        public BlockPos getLowestAuraDrainSpot(World var1, BlockPos var2, int var3, BlockPos var4);

        public BlockPos getHighestAuraDrainSpot(World var1, BlockPos var2, int var3, BlockPos var4);
    }
}

