/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.core.ModTileEntities;
import me.desht.modularrouters.util.Scheduler;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class TileEntityTemplateFrame
extends TileEntity
implements ICamouflageable {
    private static final String NBT_CAMO_NAME = "CamouflageName";
    private static final String NBT_MIMIC = "Mimic";
    private BlockState camouflage = null;
    private boolean extendedMimic;

    public TileEntityTemplateFrame() {
        super((TileEntityType)ModTileEntities.TEMPLATE_FRAME.get());
    }

    public static Optional<TileEntityTemplateFrame> getTemplateFrame(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityTemplateFrame ? Optional.of((TileEntityTemplateFrame)te) : Optional.empty();
    }

    @Override
    public BlockState getCamouflage() {
        return this.camouflage;
    }

    @Override
    public void setCamouflage(BlockState camouflage) {
        this.camouflage = camouflage;
        this.requestModelDataUpdate();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BlockCamo.CAMOUFLAGE_STATE, (Object)this.camouflage).build();
    }

    @Override
    public boolean extendedMimic() {
        return this.extendedMimic;
    }

    @Override
    public void setExtendedMimic(boolean mimic) {
        this.extendedMimic = mimic;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.camouflage = TileEntityTemplateFrame.getCamoStateFromNBT(compound);
        this.extendedMimic = compound.func_74767_n(NBT_MIMIC);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74757_a(NBT_MIMIC, this.extendedMimic);
        return TileEntityTemplateFrame.getNBTFromCamoState(compound, this.camouflage);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.camouflage = TileEntityTemplateFrame.getCamoStateFromNBT(pkt.func_148857_g());
        this.extendedMimic = pkt.func_148857_g().func_74767_n(NBT_MIMIC);
        if (this.camouflage != null && this.extendedMimic && this.camouflage.func_185906_d() > 0) {
            this.func_145831_w().func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        }
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.camouflage = TileEntityTemplateFrame.getCamoStateFromNBT(tag);
        this.extendedMimic = tag.func_74767_n(NBT_MIMIC);
        if (this.camouflage != null && this.extendedMimic && this.camouflage.func_185906_d() > 0) {
            Scheduler.client().schedule(() -> this.func_145831_w().func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c), 1L);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74757_a(NBT_MIMIC, this.extendedMimic);
        return TileEntityTemplateFrame.getNBTFromCamoState(compound, this.camouflage);
    }

    private static BlockState getCamoStateFromNBT(CompoundNBT tag) {
        if (tag.func_74764_b(NBT_CAMO_NAME)) {
            return NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l(NBT_CAMO_NAME));
        }
        return null;
    }

    private static CompoundNBT getNBTFromCamoState(CompoundNBT compound, BlockState camouflage) {
        if (camouflage != null) {
            compound.func_218657_a(NBT_CAMO_NAME, (INBT)NBTUtil.func_190009_a((BlockState)camouflage));
        }
        return compound;
    }

    public void setCamouflage(ItemStack itemStack, Direction facing, Direction routerFacing) {
        if (itemStack.func_77973_b() instanceof BlockItem) {
            this.camouflage = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
            if (this.camouflage.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
                this.camouflage = (BlockState)this.camouflage.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)facing.func_176740_k());
            } else if (this.camouflage.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
                this.camouflage = (BlockState)this.camouflage.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing);
            } else if (this.camouflage.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
                this.camouflage = (BlockState)this.camouflage.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)(facing.func_176740_k() == Direction.Axis.Y ? routerFacing : facing));
            }
        }
    }
}

