/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.block.harvester.TileHarvester;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantGrowth
extends EnchantBase {
    public EnchantGrowth(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_92089_a(ItemStack stack) {
        boolean yes = stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() instanceof HoeItem;
        return yes;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity p;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && ((p = (PlayerEntity)entity).func_175149_v() || !p.func_70089_S())) {
            return;
        }
        int level = this.getCurrentLevelTool(entity.func_184586_b(Hand.MAIN_HAND));
        if (level > 0 && !entity.field_70170_p.field_72995_K) {
            if (entity.field_70170_p.field_73012_v.nextDouble() > 0.04 / (double)level) {
                return;
            }
            int growthLimit = level * 2 + (entity.field_70170_p.func_72896_J() ? 4 : 1);
            int grown = 0;
            List<BlockPos> shape = UtilShape.squareHorizontalFull(entity.func_180425_c().func_177977_b(), level + 2);
            shape = UtilShape.repeatShapeByHeight(shape, 2);
            Collections.shuffle(shape);
            for (int i = 0; i < shape.size() && grown < growthLimit; ++i) {
                BlockPos pos = shape.get(i);
                BlockState target = entity.field_70170_p.func_180495_p(pos);
                IntegerProperty propAge = TileHarvester.getAgeProp(target);
                if (propAge == null) continue;
                int maxAge = (Integer)Collections.max(propAge.func_177700_c());
                Integer currentAge = (Integer)target.func_177229_b((IProperty)propAge);
                if (currentAge >= maxAge || !entity.field_70170_p.func_175656_a(pos, (BlockState)target.func_206870_a((IProperty)propAge, (Comparable)Integer.valueOf(currentAge + 1)))) continue;
                ++grown;
            }
            if (grown > 0) {
                UtilItemStack.damageItem(entity, entity.func_184586_b(Hand.MAIN_HAND));
            }
        }
    }
}

