/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModTileEntities;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.tile.FastHopperTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class FilteredHopperTileEntity
extends FastHopperTileEntity {
    private final IRootFilter rootFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);

    public FilteredHopperTileEntity() {
        super(ModTileEntities.filteredHopper);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(5){

            public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
                if (itemStack.func_190926_b() || !FilteredHopperTileEntity.this.rootFilter.passes(FilteredHopperTileEntity.this, itemStack)) {
                    return itemStack;
                }
                return super.insertItem(slot, itemStack, simulate);
            }
        };
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:filtered_hopper";
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = super.getCapability(cap, side);
        if (!result.isPresent()) {
            result = Capabilities.ROOT_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        if (!result.isPresent()) {
            result = Capabilities.SIMPLE_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        return result;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("RootFilter", this.rootFilter.serializeNBT());
        return tagCompound;
    }

    @Override
    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.rootFilter.deserializeNBT((INBT)tagCompound.func_74775_l("RootFilter"));
    }
}

